/* CssParser.java */
/* Generated By:JavaCC: Do not edit this line. CssParser.java */
package org.w3c.css.parser.analyzer;

import org.w3c.css.atrules.css.AtRuleCounterStyle;
import org.w3c.css.atrules.css.AtRuleFontFace;
import org.w3c.css.atrules.css.AtRuleKeyframes;
import org.w3c.css.atrules.css.AtRuleMedia;
import org.w3c.css.atrules.css.AtRulePage;
import org.w3c.css.atrules.css.AtRulePhoneticAlphabet;
import org.w3c.css.atrules.css.AtRulePreference;
import org.w3c.css.atrules.css.AtRuleSupports;
import org.w3c.css.atrules.css.AtRuleViewport;
import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.atrules.css.media.MediaRangeFeature;
import org.w3c.css.atrules.css.supports.SupportsFeature;
import org.w3c.css.atrules.svg.AtRuleColorProfile;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.ClassSelector;
import org.w3c.css.selectors.IdSelector;
import org.w3c.css.selectors.TypeSelector;
import org.w3c.css.selectors.UniversalSelector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.selectors.attributes.AttributeOneOf;
import org.w3c.css.selectors.attributes.AttributeStart;
import org.w3c.css.selectors.attributes.AttributeSubstr;
import org.w3c.css.selectors.attributes.AttributeSuffix;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.StringUtils;
import org.w3c.css.util.Util;
import org.w3c.css.util.WarningParamException;
import org.w3c.css.values.CssANPlusB;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssAttr;
import org.w3c.css.values.CssBracket;
import org.w3c.css.values.CssCalc;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssComparator;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFlexibleLength;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssHashIdent;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssImage;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssMathFunction;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssRatio;
import org.w3c.css.values.CssResolution;
import org.w3c.css.values.CssSemitone;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssSwitch;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssTypes;
import org.w3c.css.values.CssURL;
import org.w3c.css.values.CssUnicodeRange;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssVariable;
import org.w3c.css.values.CssVolume;

import static org.w3c.css.util.StringUtils.convertIdent;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;

/**
 * A CSS parser  
 *
 * @author Philippe Le Hegaret, Sijtsche Smeman, Yves Lafon
 */
public abstract class CssParser implements CssParserConstants {

    private static char hexdigits[] = { '0', '1', '2', '3',
                                        '4', '5', '6', '7',
                                        '8', '9', 'a', 'b',
                                        'c', 'd', 'e', 'f' };
    // the current atRule
    protected AtRule atRule;
    protected boolean mediaDeclaration = false;

    /**
     * The URL of the document
     */
    protected URL url;

    protected ApplContext ac;

    protected boolean incompatible_error;

    /**
     * The current context recognized by the parser (for errors).
     */
    protected ArrayList<CssSelectors> currentContext;

    /**
     * The current property recognized by the parser (for errors).
     */
    protected String currentProperty;

    /**
     * <code>true</code> if the parser should recognized Aural properties, 
     * <code>false</code> otherwise.
     */
    protected boolean mode;

    /**
     * <code>true</code> if the parser had recognize a rule,
     * <code>false</code> otherwise.
     */
    protected boolean markRule;

    private boolean reinited = false;
    private boolean charsetdeclared = false;

    // to be able to remove a ruleset if the selector is not valid
    protected boolean validSelector = true;

    /**
     * The ac for handling errors and warnings.
     * 
     * @param ac the new ac for the parser.
     */
    public final void setApplContext(ApplContext ac) {
        this.ac = ac;
    }

    /**
     * Set the attribute atRule
     *
     * @param atRule the new value for the attribute
     */
    public void setAtRule(AtRule atRule) {
        this.atRule = atRule;
    }

    /**
     * Set the attribute mediaDeclaration
     *
     * @param mediadeclaration indicator if in a media expression list or not
     */
    public void setMediaDeclaration(boolean mediadeclaration) {
        this.mediaDeclaration = mediadeclaration;
    }

    /**
     * Returns the attribute mediaDeclaration
     *
     * @return the value of the attribute
     */
    public boolean hasMediaDeclaration() {
        return mediaDeclaration;
    }

    /**
     * Returns the attribute atRule
     *
     * @return the value of the attribute
     */
    public AtRule getAtRule() {
        return atRule;
    }

    /**
     * Reinitialized the parser.
     *
     * @param stream the stream data to parse.
     * @param ac  the new ac to use for parsing.
     */
    public void ReInitWithAc(InputStream stream, ApplContext ac,
                             String charset)
    {
        InputStream is = /*new  CommentSkipperInputStream(stream);*/stream;
        if (charset == null) {
            charset = "iso-8859-1";
        }
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, charset);
        } catch (UnsupportedEncodingException uex) {
            isr = new InputStreamReader(is);
        }
        // reinit, it can not happen...
        // ...in theory ;)
        ReInit(isr);
        markRule = false;
        reinited = true;
        setApplContext(ac);
    }

    /* utilities for a parser */

    /**
     * Call by the import statement.
     *
     * @param url  The style sheet where this import statement appears.
     * @param file the file name in the import
     */
    public abstract void handleImport(URL url, String file,
                                      boolean is_url, AtRuleMedia media);

    /**
     * Call by the namespace declaration statement.
     *
     * @param url  The style sheet where this namespace statement appears.
     * @param file the file/url name in the namespace declaration
     */
    public abstract void handleNamespaceDeclaration(URL url, String prefix,
                                                    String file,
                                                    boolean is_url);

    /**
     * Call by the at-rule statement.
     *
     * @param ident  The ident for this at-rule (for example: 'font-face')
     * @param string The string associate to this at-rule
     */
    public abstract void handleAtRule(String ident, String string);

    /* added by Sijtsche Smeman */
    public abstract void addCharSet(String charset) throws ParseException;
    public abstract void newAtRule(AtRule atRule);
    public abstract void endOfAtRule();
    public abstract void setImportant(boolean important);
    public abstract void setSelectorList(ArrayList<CssSelectors> selectors);
    public abstract void addProperty(ArrayList<CssProperty> properties);
    public abstract void endOfRule();
    public abstract void removeThisRule();
    public abstract void removeThisAtRule();

    /**
     * Assign an expression to a property.  This function create a new property
     * with <code>property</code> and assign to it the expression with the
     * importance. Don't forget to set informations too.
     * <p>
     * A subclass must provide an implementation of this method. 
     *
     * @param  property  the name of the property
     * @param  values    the expression representation of values
     * @param  important <code>true</code> if values are important
     *
     * @return           <code>null</code>or a property
     * 
     * @see              org.w3c.css.properties.css.CssProperty
     */
    public abstract CssProperty handleDeclaration(String property,
                                                  CssExpression values,
                                                  boolean important)
        throws InvalidParamException;

    /**
     * Assign an expression to a mediafeature.
     * This function create a new mediafeature
     * with <code>mediaFeature</code> and assign to it the expression.
     * <p>
     * A subclass must provide an implementation of this method.
     *
     * @param  mediaFeature  the name of the media feature
     * @param  expr          the expression representation of values
     *
     * @return           <code>null</code>or a property
     *
     * @see              org.w3c.css.properties.css.CssProperty
     */
    public abstract MediaFeature handleMediaFeature(AtRuleMedia rule,
                                                    String mediaFeature,
                                                                            CssExpression expr)
               throws InvalidParamException;



    /**
     * Adds a ArrayList of properties to a selector.
     * <p>
     * A subclass must provide an implementation of this method. 
     *
     * @param selector     the selector
     * @param declarations Properties to associate with contexts
     */
    public abstract void handleRule(CssSelectors selector,
                                    ArrayList<CssProperty> declarations);

    /*Added by Sijtsche Smeman */

    /**
     * Returns the source file of the style sheet
     */
    public final String getSourceFile() {
        return getURL().toString();
    }

    /**
     * Returns the current line in the style sheet
     */
    public final int getLine() {
        //return token.beginLine;
        return 0;
    }

    /**
     * Returns the beginLine in the style sheet
     */
    public final int getBeginLine() {
        return token.beginLine;
    }

    /**
     * Returns the beginColumn in the style sheet
     */
    public final int getBeginColumn() {
        return token.beginColumn;
    }

    /**
     * Returns the endLine in the style sheet
     */
    public final int getEndLine() {
        return token.endLine;
    }

    /**
     * Returns the endColumn in the style sheet
     */
    public final int getEndColumn() {
        return token.endColumn;
    }

    /**
     * Set the URL of the style sheet.
     *
     * @param url The URL for the style sheet
     */
    public final void setURL(URL url) {
        this.url = url;
    }

    public final URL getURL() {
        return url;
    }

    /**
     * Return the next selector from the inputstream
     */
    public CssSelectors parseSelector() throws ParseException {
            return externalSelector();
    }

    /**
     * Return the next @media rule from the inputstream
     */
    public AtRuleMedia parseMediaDeclaration()  throws ParseException {
        AtRuleMedia newRule = AtRuleMedia.getInstance(ac.getCssVersion());
            mediaquerylist(newRule);
            return newRule;
    }
    /*
     * Add a value to an expression
     */
    private void setValue(CssValue v, CssExpression expr,
                          char operator, Token n, int token)
        throws ParseException {

        if ( token == FUNCTION ) {
            switch (v.getType()) {
                case CssTypes.CSS_FUNCTION:
                    CssFunction f = (CssFunction) v;
                    if (f.getParameters().hasVendorExtensions()) {
                        expr.markVendorExtension();
                    }
                    if (f.getParameters().hasCssVariable()) {
                        expr.markCssVariable();
                    }
                    if (f.getParameters().hasCssHack()) {
                        expr.markCssHack();
                    }
                    break;
                case CssTypes.CSS_IMAGE:
                    CssImage im = (CssImage) v;
                    if (im.hasCssVariable()) {
                        expr.markCssVariable();
                    }
                    break;
                case CssTypes.CSS_COLOR:
                    CssColor co = (CssColor) v;
                    if (co.hasCssVariable()) {
                       expr.markCssVariable();
                    }
                    break;
                default:
                // do nothing
            }
        } else if ( token == FUNCTIONVAR ) {
            if (v.getType() == CssTypes.CSS_VARIABLE) {
                expr.markCssVariable();
            }
        } else if ( token == FUNCTIONCALC ) {
               CssCalc c = (CssCalc) v;
               if (c.hasCssVariable()) {
                   expr.markCssVariable();
               }
        }
        if (n != null) {
            if (ac.getCssVersion() == CssVersion.CSS1 &&
                                          (n.image).equals("inherit")) {
                    incompatible_error = true;
            }
            String val = addOperator(operator, n.image);

            if (n.kind == CssParserConstants.IDENT) {
                String s = convertIdent(val);
                if ('-' == s.charAt(0)) {
                        expr.markVendorExtension();
                }
                if (v.getRawType() == CssTypes.CSS_IDENT) {
                        v = CssIdent.getIdent(s); // might be in the setValue call
                } else {
                        v.set(s, ac);
                }
            } else if (n.kind == CssParserConstants.STRING) {
                    v.set(val, ac);
            } else {
                    v.set(val, ac);
            }
        }
        expr.addValue(v);
    }

    /*
     * Error control
     */
    private void addError(Exception e, String skippedText) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssParseException ex = new CssParseException(e);
        ex.setSkippedString(skippedText);
        ex.setProperty(currentProperty);
        ex.setContexts(currentContext);
        CssError error = new CssError(getSourceFile(), getBeginLine(),
                getBeginColumn(), getEndLine(), getEndColumn(), ex);
        ac.getFrame().addError(error);
    }

    /*
     * Error control 2
     */
    private void addError(Exception e, CssExpression exp) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }

        //	if ((exp != null) && (exp.getCount() != 0)) {
        CssParseException ex = new CssParseException(e);
        ex.setExp(exp);
        ex.setProperty(currentProperty);
        ex.setContexts(currentContext);
        CssError error = new CssError(getSourceFile(), getBeginLine(),
                getBeginColumn(), getEndLine(), getEndColumn(), ex);
        ac.getFrame().addError(error);
        //	}
    }

    private void addParseError(ParseException e, String skipped) {
          if (Util.onDebug) {
              System.err.println(e.getMessage());
              e.printStackTrace();
          }
          CssErrorToken err = new CssErrorToken(e, skipped);
          ac.getFrame().addError(err);
    }

    private static String addOperator(char operator, String value) {
        return (' ' == operator) ? value : operator+value;
    }

//<DEFAULT, IN_COMMENT>
//TOKEN :
//{ /* avoid token manager error */
//   < UNKNOWN : ~[] >
//}

/*
 * The grammar of CSS2
 */

/**
 * The main entry for the parser.
 *
 * @exception ParseException exception during the parse
 */
  final public void parserUnit() throws ParseException {Token n = null;
    try {
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HTMLSTARTTAG:
        case HTMLENDTAG:{
          ;
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HTMLSTARTTAG:{
          n = jj_consume_token(HTMLSTARTTAG);
          break;
          }
        case HTMLENDTAG:{
          n = jj_consume_token(HTMLENDTAG);
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
addError (new ParseException(ac.getMsg().getString("generator.dontmixhtml")), n.image);
      }
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CHARSET_SYM:{
          ;
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        charset();
      }
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:
        case CDO:
        case CDC:{
          ;
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          break label_3;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        case CDO:{
          jj_consume_token(CDO);
          break;
          }
        case CDC:{
          jj_consume_token(CDC);
          break;
          }
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IMPORT_SYM:{
          ;
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          break label_4;
        }
        importDeclaration();
        ignoreStatement();
      }
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NAMESPACE_SYM:{
          ;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          break label_5;
        }
        namespaceDeclaration();
        ignoreStatement();
      }
      afterImportDeclaration();
      jj_consume_token(0);
    } catch (TokenMgrError err) {
addError (new ParseException(ac.getMsg().getString("generator.unrecognize")),
            err.getMessage());
    }
  }

  final public Token ident() throws ParseException {Token n = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      n = jj_consume_token(IDENT);
      break;
      }
    case AND:{
      n = jj_consume_token(AND);
      break;
      }
    case OR:{
      n = jj_consume_token(OR);
      break;
      }
    case NOT:{
      n = jj_consume_token(NOT);
      break;
      }
    case ONLY:{
      n = jj_consume_token(ONLY);
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
  }

  final public void charset() throws ParseException {Token n = null;
    Token charsetToken = null;
    Token space1Token = null;
    Token space2Token = null;
    Token semicolonToken = null;
    int nb_S = 0;
    CssVersion version = ac.getCssVersion();
    try {
      charsetToken = jj_consume_token(CHARSET_SYM);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[8] = jj_gen;
          break label_6;
        }
        space1Token = jj_consume_token(S);
nb_S++;
      }
      n = jj_consume_token(STRING);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_7;
        }
        space2Token = jj_consume_token(S);
      }
      semicolonToken = jj_consume_token(SEMICOLON);
if (charsetdeclared && !reinited) {
                    {if (true) throw new ParseException(
                                     ac.getMsg().getString("parser.charset"));}
                }
                // the @charset must be at the beginning of the document
                if(charsetToken.beginLine != 1 ||
                   charsetToken.beginColumn != 1) {
                    {if (true) throw new ParseException(
                                  ac.getMsg().getString("parser.charset"));}
                }
                if (version == CssVersion.CSS1) {
                    {if (true) throw new ParseException(ac.getMsg().getString(
                                                         "parser.charsetcss1"));}
                }
                // stricter rule for CSS21 and soon for CSS3
                // if equal of above CSS21
                if (version.compareTo(CssVersion.CSS21) >= 0) {
                    // single space before
                    // case sensitive
                    // no space before ;
                    // no comments
                    // string must start with "
                    if ( (nb_S != 1) ||
                         (!"@charset".equals(charsetToken.image)) ||
                         (!" ".equals(space1Token.image)) ||
                         (space2Token != null &&
                          !"".equals(space2Token.image)) ||
                         (space1Token.specialToken != null) ||
                         (n.specialToken != null) ||
                         (semicolonToken.specialToken != null) ||
                         (n.image.charAt(0) != '\"')
                        ) {
                        {if (true) throw new ParseException(ac.getMsg().getString(
                                                     "parser.charsetspecial"));}
                    }
                }
                if (!charsetdeclared) {
                    addCharSet(n.image.substring(1, n.image.length()-1));
                    charsetdeclared = true;
                } else {
                    reinited = false;
                }
    } catch (Exception e) {
String skip = charsetToken +
            ((space1Token == null) ? "" : space1Token.image) +
            n +
            ((space2Token == null) ? "" : space2Token.image) +
            ";";
        addError(e, skip);
    }
  }

  final public void nested_at_rules() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MEDIA_SYM:{
      media();
      break;
      }
    case PAGE_SYM:{
      page();
      break;
      }
    case FONT_FACE_SYM:{
      fontFace();
      break;
      }
    case KEYFRAMES_SYM:{
      keyframes();
      break;
      }
    case PREF_SYM:{
      preference();
      break;
      }
    case VIEWPORT_SYM:{
      viewport();
      break;
      }
    case COLOR_PROFILE:{
      colorprofile();
      break;
      }
    case COUNTER_STYLE_SYM:{
      counterstyle();
      break;
      }
    case PHONETIC_ALPHABET_SYM:{
      phoneticAlphabet();
      break;
      }
    case SUPPORTS_SYM:{
      supports();
      break;
      }
    case ATKEYWORD:{
      atRuleDeclaration();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void afterImportDeclaration() throws ParseException {String ret;
    label_8:
    while (true) {
      ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case HASHIDENT:
      case HASH:
      case LBRACKET:
      case ANY:
      case DOT:
      case COLON:
      case RELFONTLENGTH:
      case RELVIEWLENGTH:
      case ABSOLUTLENGTH:
      case ANGLE:
      case TIME:
      case FREQ:
      case RESOLUTION:
      case DIMEN:
      case PSEUDOELEMENT_SYM:
      case 153:{
        ruleSet();
        break;
        }
      case PAGE_SYM:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case KEYFRAMES_SYM:
      case PREF_SYM:
      case COLOR_PROFILE:
      case COUNTER_STYLE_SYM:
      case PHONETIC_ALPHABET_SYM:
      case SUPPORTS_SYM:
      case VIEWPORT_SYM:
      case ATKEYWORD:{
        nested_at_rules();
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        ret = skipStatement();
if ((ret == null) || (ret.length() == 0)) {
                {if ("" != null) return;}
            }
          // quite ugly but necessary to avoid probably a lot of changes in the
          // grammar, still having a beautiful error message
            else if (ret.startsWith("@charset")) {
                ParseException e =
                new ParseException(ac.getMsg().getString("parser.charset"));
                addError(e, ret);
            } else if (ret.startsWith("@import")) {
                ParseException e =
                new ParseException(ac.getMsg().getString("parser.import_not_allowed"));
                addError(e, ret);
            } else {
                // ignore unterminated comment
                CssVersion version = ac.getCssVersion();
                if (!ret.startsWith("/*") || (version.compareTo(CssVersion.CSS3) < 0)) {
                    ParseException e = new ParseException(ac.getMsg().getString("generator.unrecognize"));
                    addError(e, ret);
                } else {
                    // read until the end
                    Token t = getToken(0);
                    while(t.kind != EOF) {
                        t = getNextToken();
                    }
                }
            }
      }
      ignoreStatement();
    }
  }

  final public void ignoreStatement() throws ParseException {
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CDO:
      case CDC:{
        ;
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CDO:{
        jj_consume_token(CDO);
        break;
        }
      case CDC:{
        jj_consume_token(CDC);
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[14] = jj_gen;
          break label_10;
        }
        jj_consume_token(S);
      }
    }
  }

  final public void namespaceDeclaration() throws ParseException {Token n=null;
    Token v=null;
    boolean is_url; /* for formatting */
    String nsname;
    String prefix = null;
    CssValue val;
    jj_consume_token(NAMESPACE_SYM);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        break label_11;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:{
      n = ident();
prefix = convertIdent(n.image);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[16] = jj_gen;
          break label_12;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING:{
      v = jj_consume_token(STRING);
is_url = false;
              nsname = v.image.substring(1, v.image.length()-1);
      break;
      }
    case URL:{
      v = jj_consume_token(URL);
is_url = true;
              val = new CssURL();
              ((CssURL) val).set(v.image, ac, url);
              nsname = (String) val.get();
              if ((nsname.charAt(0) == '"')
                  || (nsname.charAt(0) == '\'')) {
                  nsname = nsname.substring(1, nsname.length()-1);
              }
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_13;
      }
      jj_consume_token(S);
    }
    jj_consume_token(SEMICOLON);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_14;
      }
      jj_consume_token(S);
    }
// If less than CSS 3
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            addError(new InvalidParamException("at-rule", "@namespace", ac),
                     (n==null)?"default":n.toString());
        } else {
            if (v != null) {
                handleNamespaceDeclaration(getURL(), prefix, nsname, is_url);
            }
        }
  }

/**
 * The import statement
 *
 * @exception ParseException exception during the parse
 */
  final public void importDeclaration() throws ParseException {Token n;
    AtRuleMedia media = AtRuleMedia.getInstance(ac.getCssVersion());
    CssValue val;
    String importFile;
    boolean is_url = false;
    try {
      jj_consume_token(IMPORT_SYM);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          break label_15;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING:{
        n = jj_consume_token(STRING);
importFile = n.image.substring(1, n.image.length() -1);
                is_url = false;
        break;
        }
      case URL:{
        n = jj_consume_token(URL);
val = new CssURL();
                ((CssURL) val).set(n.image, ac, url);
                importFile = (String) val.get();
                if ((importFile.charAt(0) == '"')
                    || (importFile.charAt(0) == '\'')) {
                    importFile = importFile.substring(1, importFile.length()-1);
                }
                is_url = true;
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          break label_16;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ONLY:
      case NOT:
      case IDENT:
      case LPAREN:{
        mediaquerylist(media);
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          break label_17;
        }
        jj_consume_token(S);
      }
handleImport(getURL(), importFile, is_url, media);
    } catch (ParseException e) {
addError(e, skipStatement());
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public AtRuleMedia media() throws ParseException {AtRule old = getAtRule();
    AtRuleMedia newRule = AtRuleMedia.getInstance(ac.getCssVersion());
    setAtRule(newRule);
    Token n;
    CssProperty p = null;
    boolean isCss1 =  (ac.getCssVersion() == CssVersion.CSS1);
    boolean emptyList = true;
    int begl = 0, begc = 0, endl = 0, endc = 0;
    try {
      n = jj_consume_token(MEDIA_SYM);
begl = getBeginLine();
            begc = getBeginColumn();
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          break label_18;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ONLY:
      case NOT:
      case IDENT:
      case LPAREN:{
        mediaquerylist(newRule);
String media = getAtRule().toString();
                    emptyList = false;
                    if (ac.getMedium() != null &&
                        !(media.equals(ac.getMedium())) &&
                        !(ac.getMedium().equals("all"))) {

                        ac.getFrame().addWarning("noothermedium", getAtRule().toString());
                    }
                    if (isCss1) {
                        skipStatement();
                        addError(new InvalidParamException("noatruleyet", "", ac),
                                 getAtRule().toString());
                    } else {
                        newAtRule(getAtRule());
                    }
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
endl = getEndLine() ; endc = getEndColumn() ;
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[28] = jj_gen;
          break label_19;
        }
        jj_consume_token(S);
      }
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case ANY:
        case DOT:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case PAGE_SYM:
        case MEDIA_SYM:
        case FONT_FACE_SYM:
        case KEYFRAMES_SYM:
        case PREF_SYM:
        case COLOR_PROFILE:
        case COUNTER_STYLE_SYM:
        case PHONETIC_ALPHABET_SYM:
        case SUPPORTS_SYM:
        case VIEWPORT_SYM:
        case ATKEYWORD:
        case 153:{
          ;
          break;
          }
        default:
          jj_la1[29] = jj_gen;
          break label_20;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case ANY:
        case DOT:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case 153:{
          ruleSet();
          break;
          }
        case PAGE_SYM:
        case MEDIA_SYM:
        case FONT_FACE_SYM:
        case KEYFRAMES_SYM:
        case PREF_SYM:
        case COLOR_PROFILE:
        case COUNTER_STYLE_SYM:
        case PHONETIC_ALPHABET_SYM:
        case SUPPORTS_SYM:
        case VIEWPORT_SYM:
        case ATKEYWORD:{
          nested_at_rules();
          break;
          }
        default:
          jj_la1[30] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          break label_21;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                         endOfAtRule();
                     }
    } catch (ParseException e) {
if (!isCss1) {
                addError(e, skipStatement());
            }
            newRule = null;
    } finally {
if (emptyList && ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            ac.getFrame().addError(new CssError(getSourceFile(), begl, begc, endl, endc,
                                                new InvalidParamException("emptymedia", ac)));
        }
        setAtRule(old);
        {if ("" != null) return newRule;}
    }
    throw new Error("Missing return statement in function");
  }

  final public void ratio(CssExpression exp, char operator) throws ParseException {Token w,h,n;
    w = jj_consume_token(NUMBER);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        break label_22;
      }
      jj_consume_token(S);
    }
    jj_consume_token(DIV);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        break label_23;
      }
      jj_consume_token(S);
    }
    h = jj_consume_token(NUMBER);
StringBuilder sb = new StringBuilder();
     sb.append(w.image).append('/').append(h.image);
     n = Token.newToken(w.kind, sb.toString());
     setValue(new CssRatio(), exp, operator, n, NUMBER);
  }

  final public void mediaquerylist(AtRuleMedia mediaRule) throws ParseException {
    mediaquery(mediaRule);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        break label_24;
      }
      jj_consume_token(COMMA);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          break label_25;
        }
        jj_consume_token(S);
      }
      mediaquery(mediaRule);
    }
  }

  final public void mediaquery(AtRuleMedia mediaRule) throws ParseException {Token n;
  String mediarestrictor = null;
    if (jj_2_1(3)) {
      mediacondition(mediaRule, true, null);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ONLY:
      case NOT:
      case IDENT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ONLY:
        case NOT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NOT:{
            n = jj_consume_token(NOT);
            break;
            }
          case ONLY:{
            n = jj_consume_token(ONLY);
            break;
            }
          default:
            jj_la1[36] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
mediarestrictor = convertIdent(n.image);
          label_26:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[37] = jj_gen;
              break label_26;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[38] = jj_gen;
          ;
        }
        n = jj_consume_token(IDENT);
mediaRule.addMedia(mediarestrictor, convertIdent(n.image), ac);
        label_27:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[39] = jj_gen;
            break label_27;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          n = jj_consume_token(AND);
mediarestrictor = convertIdent(n.image);
          label_28:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[40] = jj_gen;
              break label_28;
            }
            jj_consume_token(S);
          }
          mediaconditionwithoutor(mediaRule, false, mediarestrictor);
          break;
          }
        default:
          jj_la1[41] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void mediacondition(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {Token n;
    String combinator = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      n = jj_consume_token(NOT);
combinator = convertIdent(n.image);
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[43] = jj_gen;
          break label_29;
        }
        jj_consume_token(S);
      }
      mediainparens(mediaRule, defaultMedia, combinator);
      break;
      }
    case LPAREN:{
      mediainparens(mediaRule, defaultMedia, null);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          label_30:
          while (true) {
            n = jj_consume_token(AND);
combinator = convertIdent(n.image);
            label_31:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[44] = jj_gen;
                break label_31;
              }
              jj_consume_token(S);
            }
            mediainparens(mediaRule, false, combinator);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case AND:{
              ;
              break;
              }
            default:
              jj_la1[45] = jj_gen;
              break label_30;
            }
          }
          break;
          }
        case OR:{
          label_32:
          while (true) {
            n = jj_consume_token(OR);
combinator = convertIdent(n.image);
            label_33:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[46] = jj_gen;
                break label_33;
              }
              jj_consume_token(S);
            }
            mediainparens(mediaRule, false, combinator);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case OR:{
              ;
              break;
              }
            default:
              jj_la1[47] = jj_gen;
              break label_32;
            }
          }
          break;
          }
        default:
          jj_la1[48] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void mediaconditionwithoutor(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {Token n;
    String mediarestrictor = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      n = jj_consume_token(NOT);
mediarestrictor = convertIdent(n.image);
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          break label_34;
        }
        jj_consume_token(S);
      }
      mediainparens(mediaRule, defaultMedia, mediarestrictor);
      break;
      }
    case LPAREN:{
      mediainparens(mediaRule, defaultMedia, comb);
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          ;
          break;
          }
        default:
          jj_la1[52] = jj_gen;
          break label_35;
        }
        n = jj_consume_token(AND);
mediarestrictor = convertIdent(n.image);
        label_36:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[53] = jj_gen;
            break label_36;
          }
          jj_consume_token(S);
        }
        mediainparens(mediaRule, defaultMedia, mediarestrictor);
      }
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void mediainparens(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {CssExpression val = null;
  String mediaFeatureName = null;
  Token n;
    if (jj_2_2(4)) {
      jj_consume_token(LPAREN);
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          break label_37;
        }
        jj_consume_token(S);
      }
      mediacondition(mediaRule, defaultMedia, comb);
      jj_consume_token(RPAREN);
      label_38:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[56] = jj_gen;
          break label_38;
        }
        jj_consume_token(S);
      }
    } else if (jj_2_3(5)) {
      mediarange(mediaRule, defaultMedia, comb);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        mediaexpression(mediaRule, defaultMedia, comb);
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void mediaexpression(AtRuleMedia mediaRule, boolean defaultMedia, String comb) throws ParseException {CssExpression val = null;
  String mediaFeatureName = null;
  Token n;
    jj_consume_token(LPAREN);
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        break label_39;
      }
      jj_consume_token(S);
    }
    n = jj_consume_token(IDENT);
// here we add the default media if not present
       if (defaultMedia) {
           mediaRule.addMedia(null, null, ac);
       }
       mediaFeatureName = convertIdent(n.image);
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        break label_40;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      label_41:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[60] = jj_gen;
          break label_41;
        }
        jj_consume_token(S);
      }
      val = mediaexpr();
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        break label_42;
      }
      jj_consume_token(S);
    }
MediaFeature mf = handleMediaFeature(mediaRule, mediaFeatureName, val);
        if (mf != null) {
            mediaRule.addMediaFeature(mf, ac);
            mf.setCombinator(comb);
            // mf.setParens();
        } else {
            if (defaultMedia) {
                mediaRule.removeLastMedia();
            }
        }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void supports() throws ParseException {AtRule old = getAtRule();
    AtRuleSupports newRule = new AtRuleSupports();
    setAtRule(newRule);
    Token n;
    CssProperty p = null;
    CssVersion version = ac.getCssVersion();
    boolean isCss1 =  (version == CssVersion.CSS1);
    SupportsFeature sf;
    try {
      n = jj_consume_token(SUPPORTS_SYM);
      label_43:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[63] = jj_gen;
          break label_43;
        }
        jj_consume_token(S);
      }
if (version.compareTo(CssVersion.CSS3) < 0) {
                skipStatement();
                addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
            }
      //
              // handle supports rules
              //
              sf = supports_condition(newRule);
newRule.addFeature(sf, ac); newAtRule(getAtRule());
      jj_consume_token(LBRACE);
      label_44:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[64] = jj_gen;
          break label_44;
        }
        jj_consume_token(S);
      }
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case ANY:
        case DOT:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case PAGE_SYM:
        case MEDIA_SYM:
        case FONT_FACE_SYM:
        case KEYFRAMES_SYM:
        case PREF_SYM:
        case COLOR_PROFILE:
        case COUNTER_STYLE_SYM:
        case PHONETIC_ALPHABET_SYM:
        case SUPPORTS_SYM:
        case VIEWPORT_SYM:
        case ATKEYWORD:
        case 153:{
          ;
          break;
          }
        default:
          jj_la1[65] = jj_gen;
          break label_45;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case ANY:
        case DOT:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case 153:{
          ruleSet();
          break;
          }
        case PAGE_SYM:
        case MEDIA_SYM:
        case FONT_FACE_SYM:
        case KEYFRAMES_SYM:
        case PREF_SYM:
        case COLOR_PROFILE:
        case COUNTER_STYLE_SYM:
        case PHONETIC_ALPHABET_SYM:
        case SUPPORTS_SYM:
        case VIEWPORT_SYM:
        case ATKEYWORD:{
          nested_at_rules();
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      label_46:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          break label_46;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                 endOfAtRule();
             }
    } catch (ParseException e) {
if (!isCss1) {
              addError(e, skipStatement());
          }
          newRule = null;
    } finally {
setAtRule(old);
    }
  }

  final public SupportsFeature supports_condition(AtRuleSupports supportsRule) throws ParseException {Token t;
    SupportsFeature f = null;
    SupportsFeature nf, mf;
    boolean got_multi = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      jj_consume_token(NOT);
      label_47:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[68] = jj_gen;
          break label_47;
        }
      }
      nf = supports_condition_in_parens(supportsRule);
nf.setNot(true); {if ("" != null) return nf;}
      break;
      }
    case LPAREN:{
      nf = supports_condition_in_parens(supportsRule);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          label_48:
          while (true) {
            jj_consume_token(AND);
            label_49:
            while (true) {
              jj_consume_token(S);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[69] = jj_gen;
                break label_49;
              }
            }
            mf = supports_condition_in_parens(supportsRule);
if (f == null) {
                                                               f = new SupportsFeature();
                                                               f.addFeature(nf);
                                                           }
                                                           mf.setAnd(true);
                                                           f.addFeature(mf);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case AND:{
              ;
              break;
              }
            default:
              jj_la1[70] = jj_gen;
              break label_48;
            }
          }
          break;
          }
        case OR:{
          label_50:
          while (true) {
            jj_consume_token(OR);
            label_51:
            while (true) {
              jj_consume_token(S);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[71] = jj_gen;
                break label_51;
              }
            }
            mf = supports_condition_in_parens(supportsRule);
if (f == null) {
                                                               f = new SupportsFeature();
                                                               f.addFeature(nf);
                                                           }
                                                           mf.setOr(true);
                                                           f.addFeature(mf);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case OR:{
              ;
              break;
              }
            default:
              jj_la1[72] = jj_gen;
              break label_50;
            }
          }
          break;
          }
        default:
          jj_la1[73] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        ;
      }
if (f == null) {
            {if ("" != null) return nf;}
        }
        {if ("" != null) return f;}
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SupportsFeature supports_condition_in_parens(AtRuleSupports supportsRule) throws ParseException {CssProperty p;
    SupportsFeature f = new SupportsFeature();
    SupportsFeature nf;
    jj_consume_token(LPAREN);
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        break label_52;
      }
      jj_consume_token(S);
    }
    if (jj_2_4(3)) {
      nf = supports_condition(supportsRule);
f.addFeature(nf);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case GREATER:
      case COMMA:
      case TILDE:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case HASHIDENT:
      case CUSTOM_PROPERTY_NAME:
      case EQ:
      case DIV:
      case LBRACKET:
      case RBRACKET:
      case ANY:
      case DOT:
      case RPAREN:
      case LPAREN:
      case COLON:
      case ATKEYWORD:
      case 146:
      case 147:
      case 148:
      case 149:
      case 150:
      case 151:
      case 152:
      case 153:{
        p = declaration();
f.setProperty(p);
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[78] = jj_gen;
        break label_53;
      }
      jj_consume_token(S);
    }
{if ("" != null) return f;}
    throw new Error("Missing return statement in function");
  }

  final public void general_enclosed(AtRuleSupports supportsRule) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FUNCTION:{
      jj_consume_token(FUNCTION);
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      break;
      }
    default:
      jj_la1[79] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_54:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        break label_54;
      }
      jj_consume_token(S);
    }
    label_55:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        ;
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        break label_55;
      }
      ident();
    }
    jj_consume_token(RPAREN);
    label_56:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        break label_56;
      }
      jj_consume_token(S);
    }
  }

  final public void unused_production_generic_syntax() throws ParseException {CssExpression values = new CssExpression();
    jj_consume_token(LPAREN);
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        break label_57;
      }
      jj_consume_token(S);
    }
    term(values);
    jj_consume_token(RPAREN);

  }

  final public void unused_production_definition() throws ParseException {CssExpression values = new CssExpression();
    jj_consume_token(LBRACKET);
    label_58:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        break label_58;
      }
      jj_consume_token(S);
    }
    term(values);
    jj_consume_token(RBRACKET);

  }

/**
 * @exception ParseException exception during the parse
 */
  final public void page() throws ParseException {Token        n        = null                ;
    ArrayList<CssProperty>       collectv = new ArrayList<CssProperty>();
    CssSelectors s        = new CssSelectors(ac);
    AtRule       old      = getAtRule()         ;
    AtRulePage   newRule  = AtRulePage.getInstance(ac.getCssVersion());
    setAtRule(newRule);
    s.setAtRule(getAtRule());
    boolean isCss1 = (ac.getCssVersion() == CssVersion.CSS1);
    boolean gotContent = false;
    try {
      jj_consume_token(PAGE_SYM);
if (!isCss1) newAtRule(newRule);
      label_59:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[85] = jj_gen;
          break label_59;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case COLON:{
        page_selector_list(newRule);
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      label_60:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[87] = jj_gen;
          break label_60;
        }
        jj_consume_token(S);
      }
      gotContent = pageContent();
      jj_consume_token(RBRACE);
      label_61:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[88] = jj_gen;
          break label_61;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                    if (gotContent) {
                        endOfRule();
                    }
                    endOfAtRule();
                }
    } catch (InvalidParamException ie) {
if (!isCss1) {
            skipStatement();
            removeThisAtRule();
            ac.getFrame()
                .addError(new CssError(getSourceFile(), getBeginLine(),
                    getBeginColumn(), getEndLine(), getEndColumn(), ie));
        }
    } catch (ParseException e) {
if (!isCss1) {
            removeThisAtRule();
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public boolean pageContent() throws ParseException {CssProperty prop;
    ArrayList<CssProperty> v = null;
    ArrayList<CssProperty> allv = new ArrayList<CssProperty>();
    CssSelectors s        = new CssSelectors(ac);
    boolean gotContent = false;
    v = declarations();
if ( v != null ) {
             gotContent = true;
             allv.addAll(v);
         }
    label_62:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PAGE_TOP_LEFT_CORNER:
      case PAGE_TOP_LEFT:
      case PAGE_TOP_CENTER:
      case PAGE_TOP_RIGHT:
      case PAGE_TOP_RIGHT_CORNER:
      case PAGE_BOTTOM_LEFT_CORNER:
      case PAGE_BOTTOM_LEFT:
      case PAGE_BOTTOM_CENTER:
      case PAGE_BOTTOM_RIGHT:
      case PAGE_BOTTOM_RIGHT_CORNER:
      case PAGE_LEFT_TOP:
      case PAGE_LEFT_MIDDLE:
      case PAGE_LEFT_BOTTOM:
      case PAGE_RIGHT_TOP:
      case PAGE_RIGHT_MIDDLE:
      case PAGE_RIGHT_BOTTOM:{
        ;
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        break label_62;
      }
      prefAtRule();
gotContent = true;
      v = declarations();
if ( v != null ) {
                             allv.addAll(v);
                          }
    }
if ( allv.isEmpty() ) {
               if (!gotContent) ac.getFrame().addWarning("no-declaration");
           } else {
               addProperty(allv);
               handleRule(s, allv);
           }
           {if ("" != null) return gotContent;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<CssProperty> prefAtRule() throws ParseException {Token n;
    ArrayList<CssProperty> v;
    AtRulePage newRule = AtRulePage.getInstance(ac.getCssVersion());
    AtRule       old      = getAtRule();
    CssSelectors s = new CssSelectors(ac);
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PAGE_TOP_LEFT_CORNER:{
        n = jj_consume_token(PAGE_TOP_LEFT_CORNER);
        break;
        }
      case PAGE_TOP_LEFT:{
        n = jj_consume_token(PAGE_TOP_LEFT);
        break;
        }
      case PAGE_TOP_CENTER:{
        n = jj_consume_token(PAGE_TOP_CENTER);
        break;
        }
      case PAGE_TOP_RIGHT:{
        n = jj_consume_token(PAGE_TOP_RIGHT);
        break;
        }
      case PAGE_TOP_RIGHT_CORNER:{
        n = jj_consume_token(PAGE_TOP_RIGHT_CORNER);
        break;
        }
      case PAGE_BOTTOM_LEFT_CORNER:{
        n = jj_consume_token(PAGE_BOTTOM_LEFT_CORNER);
        break;
        }
      case PAGE_BOTTOM_LEFT:{
        n = jj_consume_token(PAGE_BOTTOM_LEFT);
        break;
        }
      case PAGE_BOTTOM_CENTER:{
        n = jj_consume_token(PAGE_BOTTOM_CENTER);
        break;
        }
      case PAGE_BOTTOM_RIGHT:{
        n = jj_consume_token(PAGE_BOTTOM_RIGHT);
        break;
        }
      case PAGE_BOTTOM_RIGHT_CORNER:{
        n = jj_consume_token(PAGE_BOTTOM_RIGHT_CORNER);
        break;
        }
      case PAGE_LEFT_TOP:{
        n = jj_consume_token(PAGE_LEFT_TOP);
        break;
        }
      case PAGE_LEFT_MIDDLE:{
        n = jj_consume_token(PAGE_LEFT_MIDDLE);
        break;
        }
      case PAGE_LEFT_BOTTOM:{
        n = jj_consume_token(PAGE_LEFT_BOTTOM);
        break;
        }
      case PAGE_RIGHT_TOP:{
        n = jj_consume_token(PAGE_RIGHT_TOP);
        break;
        }
      case PAGE_RIGHT_MIDDLE:{
        n = jj_consume_token(PAGE_RIGHT_MIDDLE);
        break;
        }
      case PAGE_RIGHT_BOTTOM:{
        n = jj_consume_token(PAGE_RIGHT_BOTTOM);
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
((org.w3c.css.atrules.css3.AtRulePage) newRule).setKeyword(convertIdent(n.image).substring(1));
            setAtRule(newRule);
            s.setAtRule(getAtRule());
            newAtRule(getAtRule());
      label_63:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[91] = jj_gen;
          break label_63;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_64:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[92] = jj_gen;
          break label_64;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
if ( v == null ) {
                        ac.getFrame().addWarning("no-declaration");
                    } else {
                        addProperty(v);
                        handleRule(s, v);
                    }
                    endOfRule();
                    endOfAtRule();
      label_65:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[93] = jj_gen;
          break label_65;
        }
        jj_consume_token(S);
      }
// FIXME
                {if ("" != null) return v;}
    } catch (ParseException e) {
addError(e, skipStatement());
    } finally {
setAtRule(old);
    }
    throw new Error("Missing return statement in function");
  }

  final public void page_selector_list(AtRulePage pageRule) throws ParseException {Token n = null;
    Token p = null;
    Token o = null;
    boolean gotFirst = false;
    String ns = null;
    ArrayList<String> ps = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:{
      n = ident();
ns = convertIdent(n.image);
      label_66:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COLON:{
          ;
          break;
          }
        default:
          jj_la1[94] = jj_gen;
          break label_66;
        }
        jj_consume_token(COLON);
        p = ident();
if (ps == null) { ps = new ArrayList<String>(); } ps.add(":"+convertIdent(p.image));
      }
pageRule.addSelector(ns, ps, ac);
        ns = null; ps = null;
      break;
      }
    case COLON:{
      label_67:
      while (true) {
        jj_consume_token(COLON);
        p = ident();
if (ps == null) { ps = new ArrayList<String>(); } ps.add(":"+convertIdent(p.image));
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COLON:{
          ;
          break;
          }
        default:
          jj_la1[95] = jj_gen;
          break label_67;
        }
      }
pageRule.addSelector(null, ps, ac);
        ps = null;
      break;
      }
    default:
      jj_la1[96] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_68:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[97] = jj_gen;
        break label_68;
      }
      jj_consume_token(S);
    }
    label_69:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[98] = jj_gen;
        break label_69;
      }
      jj_consume_token(COMMA);
      label_70:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[99] = jj_gen;
          break label_70;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
ns = convertIdent(n.image);
        label_71:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COLON:{
            ;
            break;
            }
          default:
            jj_la1[100] = jj_gen;
            break label_71;
          }
          jj_consume_token(COLON);
          p = ident();
if (ps == null) { ps = new ArrayList<String>(); } ps.add(":"+convertIdent(p.image));
        }
pageRule.addSelector(ns, ps, ac);
        ns = null; ps = null;
        break;
        }
      case COLON:{
        label_72:
        while (true) {
          jj_consume_token(COLON);
          p = ident();
if (ps == null) { ps = new ArrayList<String>(); } ps.add(":"+convertIdent(p.image));
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COLON:{
            ;
            break;
            }
          default:
            jj_la1[101] = jj_gen;
            break label_72;
          }
        }
pageRule.addSelector(null, ps, ac);
        ps = null;
        break;
        }
      default:
        jj_la1[102] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_73:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[103] = jj_gen;
          break label_73;
        }
        jj_consume_token(S);
      }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssSelectors keyframe_selector(CssSelectors next) throws ParseException {CssSelectors selector = new CssSelectors(ac, next);
    selector.setAtRule(getAtRule());
    Token n;
    Token op = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
CssIdent ident = new CssIdent();
      ident.set(convertIdent(n.image), ac);
      AtRuleKeyframes.checkSelectorValue(ident, ac);
      selector.addType(new TypeSelector(ident.toString()));
        break;
        }
      case PLUS:
      case MINUS:
      case PERCENTAGE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case PLUS:{
            op = jj_consume_token(PLUS);
            break;
            }
          case MINUS:{
            op = jj_consume_token(MINUS);
            break;
            }
          default:
            jj_la1[104] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[105] = jj_gen;
          ;
        }
        n = jj_consume_token(PERCENTAGE);
CssPercentage p = new CssPercentage();
      if (op == null) {
        p.set(n.image, ac);
      } else {
        p.set(op.image+n.image, ac);
      }
      AtRuleKeyframes.checkSelectorValue(p, ac);
      selector.addType(new TypeSelector(n.image));
        break;
        }
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_74:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[107] = jj_gen;
          break label_74;
        }
        jj_consume_token(S);
      }
{if ("" != null) return selector;}
    } catch (InvalidParamException ie) {
ac.getFrame()
            .addError(new CssError(getSourceFile(), getBeginLine(),
                getBeginColumn(), getEndLine(), getEndColumn(), ie));
        Token t = getToken(1);
        StringBuilder s = new StringBuilder();
        s.append(getToken(0).image);
        // eat until , { or EOF
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        }
        {if ("" != null) return null;}
    } catch (ParseException e) {
// TODO fix the error
        Token t = getToken(1);
        int _line = t.beginLine;
        int _col  = t.beginColumn;
        StringBuilder s = new StringBuilder();
        s.append(" [");
        s.append(getToken(0).image);
        // eat until , { or EOF
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        }
        s.append(']');
        addParseError(e, s.toString());
        validSelector = true;
        {if ("" != null) return null;}
    }
    throw new Error("Missing return statement in function");
  }

  final public void keyframes() throws ParseException {Token n;
  ArrayList<CssProperty> v;
  AtRule old = getAtRule();
  AtRuleKeyframes krule = new AtRuleKeyframes("-internal-");
  setAtRule(krule);
  CssSelectors s;
  ArrayList<CssSelectors> sl;
  CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(KEYFRAMES_SYM);
      label_75:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[108] = jj_gen;
          break label_75;
        }
      }
      n = ident();
      label_76:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[109] = jj_gen;
          break label_76;
        }
        jj_consume_token(S);
      }
krule.setName(convertIdent(n.image));
      if (version.compareTo(CssVersion.CSS3) < 0) {
        skipStatement();
        addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
      } else {
        newAtRule(getAtRule());
      }
      jj_consume_token(LBRACE);
      label_77:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[110] = jj_gen;
          break label_77;
        }
        jj_consume_token(S);
      }
      label_78:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case PERCENTAGE:{
          ;
          break;
          }
        default:
          jj_la1[111] = jj_gen;
          break label_78;
        }
        s = keyframe_selector(null);
sl = new ArrayList<CssSelectors>();
        if (s != null) {
          s.setAtRule(getAtRule());
          sl.add(s);
        }
        label_79:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[112] = jj_gen;
            break label_79;
          }
          jj_consume_token(COMMA);
          label_80:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[113] = jj_gen;
              break label_80;
            }
            jj_consume_token(S);
          }
          s = keyframe_selector(null);
if (s != null) {
         s.setAtRule(getAtRule());
         sl.add(s);
       }
        }
        jj_consume_token(LBRACE);
        label_81:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[114] = jj_gen;
            break label_81;
          }
          jj_consume_token(S);
        }
        v = declarations();
        jj_consume_token(RBRACE);
        label_82:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[115] = jj_gen;
            break label_82;
          }
          jj_consume_token(S);
        }
validSelector = (sl.size() != 0);
        if (validSelector) {
          if (v == null) {
            ac.getFrame().addWarning("no-declaration");
          } else {
            boolean first = true;
            for (CssSelectors _s : sl) {
              if (first) {
                 handleRule(_s, v);
                 first = false;
              } else {
                 ArrayList<CssProperty> vcopy = new ArrayList<CssProperty>(v.size());
                 for (CssProperty p : v) {
                   vcopy.add(p.duplicate());
                 }
                 handleRule(_s, vcopy);
              }
            }
          }
          setSelectorList(sl);
          endOfRule();
        }
      }
      jj_consume_token(RBRACE);
      label_83:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[116] = jj_gen;
          break label_83;
        }
        jj_consume_token(S);
      }
endOfAtRule();
    } catch (ParseException e) {
addError(e, skipStatement());
    } finally {
setAtRule(old);
    }
  }

  final public void fontFace() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRuleFontFace());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    boolean isCss1 = (ac.getCssVersion() == CssVersion.CSS1);
    try {
      jj_consume_token(FONT_FACE_SYM);
      label_84:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[117] = jj_gen;
          break label_84;
        }
        jj_consume_token(S);
      }
if (isCss1) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_85:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[118] = jj_gen;
          break label_85;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_86:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[119] = jj_gen;
          break label_86;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }
                 if (v == null) {
                     ac.getFrame().addWarning("no-declaration");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (!isCss1) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void colorprofile() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRuleColorProfile());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    CssProfile profile = ac.getCssProfile();
    boolean isSVG = ((profile == CssProfile.SVG) ||
                     (profile == CssProfile.SVGBASIC) ||
                     (profile == CssProfile.SVGTINY));
    try {
      jj_consume_token(COLOR_PROFILE);
      label_87:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[120] = jj_gen;
          break label_87;
        }
        jj_consume_token(S);
      }
if (!isSVG) {
                    skipStatement();
                    addError(new InvalidParamException("onlysvg", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_88:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[121] = jj_gen;
          break label_88;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_89:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[122] = jj_gen;
          break label_89;
        }
        jj_consume_token(S);
      }
if (isSVG) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }

                 if (v == null) {
                     //ac.getFrame().addWarning("medialist");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (isSVG) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void viewport() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRuleViewport());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(VIEWPORT_SYM);
      label_90:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[123] = jj_gen;
          break label_90;
        }
        jj_consume_token(S);
      }
if (version.compareTo(CssVersion.CSS3) < 0) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_91:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[124] = jj_gen;
          break label_91;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_92:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[125] = jj_gen;
          break label_92;
        }
        jj_consume_token(S);
      }
if (version.compareTo(CssVersion.CSS3) >= 0) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }

                 if (v == null) {
                     ac.getFrame().addWarning("no-declaration");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (version.compareTo(CssVersion.CSS3) < 0) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void counterstyle() throws ParseException {Token n;
  ArrayList<CssProperty> v;
  AtRule old = getAtRule();
  AtRuleCounterStyle csrule = new AtRuleCounterStyle();
  setAtRule(csrule);
  CssSelectors s = new CssSelectors(ac);;
  CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(COUNTER_STYLE_SYM);
      label_93:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[126] = jj_gen;
          break label_93;
        }
      }
      n = ident();
      label_94:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[127] = jj_gen;
          break label_94;
        }
        jj_consume_token(S);
      }
csrule.setName(convertIdent(n.image));
      if (version.compareTo(CssVersion.CSS3) < 0) {
        skipStatement();
        addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
      } else {
        newAtRule(getAtRule());
      }
      jj_consume_token(LBRACE);
      label_95:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[128] = jj_gen;
          break label_95;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_96:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[129] = jj_gen;
          break label_96;
        }
        jj_consume_token(S);
      }
if (version.compareTo(CssVersion.CSS3) >= 0) {
            addProperty(v);
            endOfRule();
            endOfAtRule();
         }
         if (v == null) {
            ac.getFrame().addWarning("no-declaration");
         } else {
            handleRule(s, v);
         }
    } catch (ParseException e) {
addError(e, skipStatement());
    } finally {
setAtRule(old);
    }
  }

  final public void preference() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRulePreference());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    boolean isCSS1 = (ac.getCssVersion() == CssVersion.CSS1);
    try {
      jj_consume_token(PREF_SYM);
      label_97:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          break label_97;
        }
        jj_consume_token(S);
      }
if (isCSS1) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_98:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[131] = jj_gen;
          break label_98;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_99:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[132] = jj_gen;
          break label_99;
        }
        jj_consume_token(S);
      }
if (!isCSS1) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }

                 if (v == null) {
                     ac.getFrame().addWarning("medialist");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (!isCSS1) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void phoneticAlphabet() throws ParseException {AtRule old = getAtRule();
    AtRulePhoneticAlphabet alphabetrule = new AtRulePhoneticAlphabet();
    setAtRule(alphabetrule);
    Token n;
    CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(PHONETIC_ALPHABET_SYM);
      label_100:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[133] = jj_gen;
          break label_100;
        }
        jj_consume_token(S);
      }
      n = jj_consume_token(STRING);
      label_101:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[134] = jj_gen;
          break label_101;
        }
        jj_consume_token(S);
      }
      jj_consume_token(SEMICOLON);
// FIXME comparison > CSS3
                if (version.compareTo(CssVersion.CSS3) < 0) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                }

                alphabetrule.addAlphabet(convertIdent(n.image), ac);

                if ((version != CssVersion.CSS1) && (version != CssVersion.CSS2)) {
                    newAtRule(getAtRule());
                }
    } catch (ParseException e) {
if (version != CssVersion.CSS1) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void atRuleDeclaration() throws ParseException {Token n;
    n = jj_consume_token(ATKEYWORD);
if ((n.toString().charAt(1) == '-') &&
                    ac.getTreatVendorExtensionsAsWarnings()) {
                        ac.getFrame().addWarning("at-rule", n.toString());
                } else {
                        addAtRuleError();
                }
                skipStatement();
    label_102:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        break label_102;
      }
      jj_consume_token(S);
    }
  }

  void addAtRuleError() throws ParseException {//
        ac.getFrame()
            .addError(new CssError(getSourceFile(), getBeginLine(),
                getBeginColumn(), getEndLine(), getEndColumn(),
                    new InvalidParamException("at-rule", token, ac)));
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void operator(CssExpression expr) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
if (expr.getCount() > 0) expr.setOperator(',');
      label_103:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[136] = jj_gen;
          break label_103;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[137] = jj_gen;
      ;
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String combinator() throws ParseException {String connector = " ";
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case GREATER:
    case TILDE:
    case TWOPIPES:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
connector = "+" ;
        break;
        }
      case GREATER:{
        jj_consume_token(GREATER);
connector = ">" ;
        break;
        }
      case TILDE:{
        jj_consume_token(TILDE);
connector = "~" ;
        break;
        }
      case TWOPIPES:{
        jj_consume_token(TWOPIPES);
connector = "||";
        break;
        }
      default:
        jj_la1[138] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_104:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[139] = jj_gen;
          break label_104;
        }
        jj_consume_token(S);
      }
      break;
      }
    case S:{
      label_105:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[140] = jj_gen;
          break label_105;
        }
      }
connector = " " ;
      break;
      }
    default:
      jj_la1[141] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return connector;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public char unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:{
      jj_consume_token(MINUS);
{if ("" != null) return '-';}
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
{if ("" != null) return '+';}
      break;
      }
    default:
      jj_la1[142] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public CssANPlusB anplusb() throws ParseException {Token n = null;
        Token b = null;
        char op = ' ';
        char pb = ' ';
        CssANPlusB anpb = new CssANPlusB();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:{
      n = ident();
      if (jj_2_5(2)) {
        label_106:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[143] = jj_gen;
            break label_106;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:{
          pb = unaryOperator();
          label_107:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[144] = jj_gen;
              break label_107;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[145] = jj_gen;
          ;
        }
        b = jj_consume_token(NUMBER);
      } else {
        ;
      }
anpb.set(n.image, pb, ((b != null) ? b.image : null), "An+B", ac);
                {if ("" != null) return anpb;}
      break;
      }
    default:
      jj_la1[153] = jj_gen;
      if (jj_2_8(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[146] = jj_gen;
          ;
        }
        b = jj_consume_token(NUMBER);
if (op == ' ') {
                        anpb.set(b.image, ac);
                } else {
                        anpb.set(""+op+b.image, ac);
                }
                {if ("" != null) return anpb;}
      } else if (jj_2_9(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:{
          op = unaryOperator();
          break;
          }
        default:
          jj_la1[147] = jj_gen;
          ;
        }
        n = jj_consume_token(AN);
        if (jj_2_6(2)) {
          label_108:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[148] = jj_gen;
              break label_108;
            }
            jj_consume_token(S);
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case PLUS:
          case MINUS:{
            pb = unaryOperator();
            label_109:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[149] = jj_gen;
                break label_109;
              }
              jj_consume_token(S);
            }
            break;
            }
          default:
            jj_la1[150] = jj_gen;
            ;
          }
          b = jj_consume_token(NUMBER);
        } else {
          ;
        }
anpb.set(op, n.image, pb, ((b!=null) ? b.image : null), "An+B", ac);
                {if ("" != null) return anpb;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:
        case DIMEN:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case PLUS:
          case MINUS:{
            op = unaryOperator();
            break;
            }
          default:
            jj_la1[151] = jj_gen;
            ;
          }
          n = jj_consume_token(DIMEN);
          if (jj_2_7(2)) {
            label_110:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[152] = jj_gen;
                break label_110;
              }
              jj_consume_token(S);
            }
            b = jj_consume_token(NUMBER);
          } else {
            ;
          }
anpb.set(op, n.image, ((b != null) ? b.image : null), "An+B", ac);
                {if ("" != null) return anpb;}
          break;
          }
        default:
          jj_la1[154] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String property() throws ParseException {Token n;
 Token hack= null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case GREATER:
    case COMMA:
    case TILDE:
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:
    case CUSTOM_PROPERTY_NAME:
    case EQ:
    case DIV:
    case LBRACKET:
    case RBRACKET:
    case ANY:
    case RPAREN:
    case LPAREN:
    case COLON:
    case 146:
    case 147:
    case 148:
    case 149:
    case 150:
    case 151:
    case 152:
    case 153:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case GREATER:
      case COMMA:
      case TILDE:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case EQ:
      case DIV:
      case LBRACKET:
      case RBRACKET:
      case ANY:
      case RPAREN:
      case LPAREN:
      case COLON:
      case 146:
      case 147:
      case 148:
      case 149:
      case 150:
      case 151:
      case 152:
      case 153:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case GREATER:
        case COMMA:
        case TILDE:
        case EQ:
        case DIV:
        case LBRACKET:
        case RBRACKET:
        case ANY:
        case RPAREN:
        case LPAREN:
        case COLON:
        case 146:
        case 147:
        case 148:
        case 149:
        case 150:
        case 151:
        case 152:
        case 153:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 146:{
            hack = jj_consume_token(146);
            break;
            }
          case 147:{
            hack = jj_consume_token(147);
            break;
            }
          case 148:{
            hack = jj_consume_token(148);
            break;
            }
          case 149:{
            hack = jj_consume_token(149);
            break;
            }
          case 150:{
            hack = jj_consume_token(150);
            break;
            }
          case 151:{
            hack = jj_consume_token(151);
            break;
            }
          case 152:{
            hack = jj_consume_token(152);
            break;
            }
          case 153:{
            hack = jj_consume_token(153);
            break;
            }
          case ANY:{
            hack = jj_consume_token(ANY);
            break;
            }
          case EQ:{
            hack = jj_consume_token(EQ);
            break;
            }
          case RBRACKET:{
            hack = jj_consume_token(RBRACKET);
            break;
            }
          case LBRACKET:{
            hack = jj_consume_token(LBRACKET);
            break;
            }
          case RPAREN:{
            hack = jj_consume_token(RPAREN);
            break;
            }
          case LPAREN:{
            hack = jj_consume_token(LPAREN);
            break;
            }
          case COLON:{
            hack = jj_consume_token(COLON);
            break;
            }
          case TILDE:{
            hack = jj_consume_token(TILDE);
            break;
            }
          case PLUS:{
            hack = jj_consume_token(PLUS);
            break;
            }
          case COMMA:{
            hack = jj_consume_token(COMMA);
            break;
            }
          case GREATER:{
            hack = jj_consume_token(GREATER);
            break;
            }
          case DIV:{
            hack = jj_consume_token(DIV);
            break;
            }
          default:
            jj_la1[155] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[156] = jj_gen;
          ;
        }
        n = ident();
        break;
        }
      case CUSTOM_PROPERTY_NAME:{
        n = jj_consume_token(CUSTOM_PROPERTY_NAME);
        break;
        }
      default:
        jj_la1[157] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_111:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[158] = jj_gen;
          break label_111;
        }
        jj_consume_token(S);
      }
currentProperty = convertIdent(n.image);
                 if (hack != null && !"".equals(hack)) {
                   String hackp = hack.image+currentProperty;
                   if (ac.getTreatCssHacksAsWarnings()) {
                     ac.getFrame().addWarning("css-hack", hackp);
                     {if ("" != null) return null;}
                   } else {
                     {if (true) throw new ParseException(String.format(ac.getMsg().getString("warning.css-hack"), hackp));}
                   }
                }
                {if ("" != null) return currentProperty;}
      break;
      }
    case HASHIDENT:
    case DOT:
    case ATKEYWORD:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case HASHIDENT:{
        n = jj_consume_token(HASHIDENT);
        break;
        }
      case DOT:{
        jj_consume_token(DOT);
        n = ident();
        break;
        }
      case ATKEYWORD:{
        n = jj_consume_token(ATKEYWORD);
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (ac.getTreatCssHacksAsWarnings()) {
                              ac.getFrame().addWarning("css-hack", n.image);
                              // should we continue and validate the content, or skip ?
                              currentProperty = convertIdent(n.image).substring(1);
                              {if ("" != null) return null;}
         }
        {if (true) throw new ParseException(String.format(ac.getMsg().getString("warning.css-hack"), n.image));}
      label_112:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[160] = jj_gen;
          break label_112;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[161] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<CssSelectors> selector_list() throws ParseException {CssSelectors selector;
        ArrayList<CssSelectors> context_set = new ArrayList<CssSelectors>();
    selector = complex_selector(null);
if (selector != null) {
                        context_set.add(selector);
                }
    label_113:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[162] = jj_gen;
        break label_113;
      }
      jj_consume_token(COMMA);
      label_114:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[163] = jj_gen;
          break label_114;
        }
        jj_consume_token(S);
      }
      selector = complex_selector(null);
if (selector != null) {
                        context_set.add(selector);
                }
    }
{if ("" != null) return context_set;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<CssSelectors> relative_selector_list() throws ParseException {CssSelectors selector;
        ArrayList<CssSelectors> context_set = new ArrayList<CssSelectors>();
    selector = relative_selector();
if (selector != null) {
                        context_set.add(selector);
                }
    label_115:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        break label_115;
      }
      jj_consume_token(COMMA);
      selector = relative_selector();
if (selector != null) {
                        context_set.add(selector);
                }
    }
{if ("" != null) return context_set;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void ruleSet() throws ParseException {ArrayList<CssSelectors> context_set = null;
    ArrayList<CssProperty> value_set = null;
    currentContext = context_set;
    try {
      context_set = selector_list();
      jj_consume_token(LBRACE);
validSelector = (context_set.size() > 0);
            if (validSelector) {
                currentContext = context_set;
            }
      label_116:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[165] = jj_gen;
          break label_116;
        }
        jj_consume_token(S);
      }
      value_set = declarations();
      jj_consume_token(RBRACE);
      label_117:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[166] = jj_gen;
          break label_117;
        }
        jj_consume_token(S);
      }
markRule = true;

                /*      if (value_set == null) {
			ac.getFrame().addWarning("no-declaration");
			} else {*/
                if (value_set != null) {
                    boolean first = true;
                    for (CssSelectors sel : context_set) {
                        if (first) {
                            handleRule(sel, value_set);
                            first = false;
                        } else {
                            // we need to duplicate properties in that case
                            // as property holds reference to the selectors and it interact
                            // badly with conflict detection
                            int vsize = value_set.size();
                            ArrayList<CssProperty> v = new ArrayList<CssProperty>(vsize);
                            for (CssProperty p : value_set) {
                                v.add(p.duplicate());
                            }
                            handleRule(sel, v);
                        }
                    }
                    setSelectorList(context_set);
                    endOfRule();
                }
                currentContext = null;
    } catch (ParseException e) {
if ((ac.getCssProfile() != CssProfile.MOBILE) && !context_set.isEmpty()) {
                String ret = skipStatement();
                CssVersion version = ac.getCssVersion();
                Token t1 = getToken(0);
                if (version.compareTo(CssVersion.CSS3) < 0) {
                        addError(e, ret);
                } else if ((ret != null) && !ret.contains("/*") && (t1 != null && t1.kind != EOF)) {
                        addError(e, ret);
                } else if (!context_set.isEmpty() && value_set == null) {
                        addError(e, ret);
                } else {
                        // unterminated comment... let's process
                        if (version.compareTo(CssVersion.CSS3) >= 0) {
                                markRule = true;
                                if (value_set != null) {
                                        boolean first = true;
                                        for (CssSelectors sel : context_set) {
                                                if (first) {
                                                        handleRule(sel, value_set);
                                                        first = false;
                                                } else {
                                                        // we need to duplicate properties in that case 
                                                        // as property holds reference to the selectors and it interact
                                                        // badly with conflict detection
                                                        int vsize = value_set.size();
                                                        ArrayList<CssProperty> v = new ArrayList<CssProperty>(vsize);
                                                        for (CssProperty p : value_set) {
                                                                v.add(p.duplicate());
                                                        }
                                                        handleRule(sel, v);
                                                }
                                 }
                                setSelectorList(context_set);
                                endOfRule();
                        } else {
                                addError(e, ret);
                        }
                }
                currentContext = null;
                }
        }
    } catch (TokenMgrError e) {
addError(new ParseException(e.getMessage()), skipStatement());
    }
  }

  final public ArrayList<CssProperty> declarations() throws ParseException {if(!validSelector) {
        validSelector = true;
        skip_to_matching_brace();
        return null;
    }

    CssProperty values;
    ArrayList<CssProperty> value_set   = new ArrayList<CssProperty>();
    boolean wrong_value = true;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case GREATER:
    case COMMA:
    case TILDE:
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:
    case HASHIDENT:
    case CUSTOM_PROPERTY_NAME:
    case EQ:
    case DIV:
    case LBRACKET:
    case RBRACKET:
    case ANY:
    case DOT:
    case RPAREN:
    case LPAREN:
    case COLON:
    case ATKEYWORD:
    case 146:
    case 147:
    case 148:
    case 149:
    case 150:
    case 151:
    case 152:
    case 153:{
      values = declaration();
if (values != null) {
                value_set.add(values);
                wrong_value = false;
            } /* else {
		 wrong_value = true;
		 } */
          currentProperty = null;
      break;
      }
    default:
      jj_la1[167] = jj_gen;
      ;
    }
    label_118:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        break label_118;
      }
      jj_consume_token(SEMICOLON);
      label_119:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[169] = jj_gen;
          break label_119;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case GREATER:
      case COMMA:
      case TILDE:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case HASHIDENT:
      case CUSTOM_PROPERTY_NAME:
      case EQ:
      case DIV:
      case LBRACKET:
      case RBRACKET:
      case ANY:
      case DOT:
      case RPAREN:
      case LPAREN:
      case COLON:
      case ATKEYWORD:
      case 146:
      case 147:
      case 148:
      case 149:
      case 150:
      case 151:
      case 152:
      case 153:{
        values = declaration();
if (values != null) {
                      value_set.add(values);
                      wrong_value = false;
                  }/* else {
		      wrong_value = true;
		      }*/
                currentProperty = null;
        break;
        }
      default:
        jj_la1[170] = jj_gen;
        ;
      }
    }
if (!wrong_value) {
                addProperty(value_set);
                {if ("" != null) return value_set;}
            } else {
                {if ("" != null) return null;}
            }
    throw new Error("Missing return statement in function");
  }

/** 
 * Used only when HTML is parsed, as otherwise parsing <S>* is missed 
 */
  final public ArrayList<CssProperty> attributeDeclarations() throws ParseException {ArrayList<CssProperty> p = null;
    try {
      label_120:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[171] = jj_gen;
          break label_120;
        }
        jj_consume_token(S);
      }
      p = declarations();
{if ("" != null) return p;}
    } catch (TokenMgrError tokenerror) {
{if (true) throw new ParseException(ac.getMsg().getString("generator.unrecognize"));}
    }
    throw new Error("Missing return statement in function");
  }

  final public CssSelectors relative_selector() throws ParseException {String comb = "*none*";
        CssSelectors current;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S:
    case PLUS:
    case GREATER:
    case TILDE:
    case TWOPIPES:{
      comb = combinator();
      break;
      }
    default:
      jj_la1[172] = jj_gen;
      ;
    }
current = new CssSelectors(ac);
                               switch(comb) {
                        case "+":
                                current.addNextSiblingCombinator();
                                break;
                        case ">":
                                current.addChildCombinator();
                                break;
                        case "~":
                                current.addSubsequentSiblingCombinator();
                                break;
                        case "||":
                                current.addColumnCombinator();
                                break;
                        case "*none*":
                                break;
                        default:
                                current.addDescendantCombinator();
                }
    current = complex_selector(current);
{if ("" != null) return current;}
    throw new Error("Missing return statement in function");
  }

/**
 * I made this rule to parse a selector from a document. Combinator are avoid.
 * @exception ParseException exception during the parse
 */
  final public CssSelectors externalSelector() throws ParseException {CssSelectors current;
    current = simple_selector(null);
    label_121:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        break label_121;
      }
      label_122:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[174] = jj_gen;
          break label_122;
        }
      }
      current = simple_selector(current);
    }
{if ("" != null) return current;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssSelectors simple_selector(CssSelectors next) throws ParseException {CssSelectors selector = new CssSelectors(ac, next);
    selector.setAtRule(getAtRule());
    //selector.setUserMedium(getUserMedium());

    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:
    case ANY:
    case 153:{
      type_selector(selector);
      label_123:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case DOT:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:{
          ;
          break;
          }
        default:
          jj_la1[175] = jj_gen;
          break label_123;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:{
          id_selector(selector);
          break;
          }
        case DOT:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:{
          class_selector(selector);
          break;
          }
        case LBRACKET:{
          attribute_selector(selector);
          break;
          }
        case COLON:
        case PSEUDOELEMENT_SYM:{
          pseudo(selector);
          break;
          }
        default:
          jj_la1[176] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
{if ("" != null) return selector;}
      break;
      }
    case HASHIDENT:
    case HASH:
    case LBRACKET:
    case DOT:
    case COLON:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case ANGLE:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:
    case PSEUDOELEMENT_SYM:{
      label_124:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:{
          id_selector(selector);
          break;
          }
        case DOT:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:{
          class_selector(selector);
          break;
          }
        case LBRACKET:{
          attribute_selector(selector);
          break;
          }
        case COLON:
        case PSEUDOELEMENT_SYM:{
          pseudo(selector);
          break;
          }
        default:
          jj_la1[177] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case DOT:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:{
          ;
          break;
          }
        default:
          jj_la1[178] = jj_gen;
          break label_124;
        }
      }
{if ("" != null) return selector;}
      break;
      }
    default:
      jj_la1[179] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public CssSelectors subclass_selector(CssSelectors selector) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HASHIDENT:
    case HASH:{
      id_selector(selector);
      break;
      }
    case DOT:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case ANGLE:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:{
      class_selector(selector);
      break;
      }
    case LBRACKET:{
      attribute_selector(selector);
      break;
      }
    case COLON:{
      pseudo_class_selector(selector);
      break;
      }
    default:
      jj_la1[180] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return selector;}
    throw new Error("Missing return statement in function");
  }

  final public CssSelectors complex_selector(CssSelectors sel) throws ParseException {String comb = "*none*";
        CssSelectors current;
    try {
      current = compound_selector(sel);
      label_125:
      while (true) {
        if (jj_2_10(2)) {
          ;
        } else {
          break label_125;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:
        case PLUS:
        case GREATER:
        case TILDE:
        case TWOPIPES:{
          comb = combinator();
if ((ac.getCssProfile() == CssProfile.MOBILE) ||
                                getAtRule().toString().equals("@media atsc-tv") ||
                                (ac.getCssVersion() == CssVersion.CSS1)) {
                                if (comb.equals("+") || comb.equals(">")) {
                                        {if (true) throw new InvalidParamException("nocomb", comb, ac);}
                                }
                        } else if (ac.getCssProfile() == CssProfile.TV) {
                                if (comb.equals("+")) {
                                        {if (true) throw new InvalidParamException("nocomb", comb, ac);}
                                }
                        }
                        // if version < CSS3, ~ is undefined
                        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                                if (comb.equals("~") || comb.equals("||")) {
                                        {if (true) throw new InvalidParamException("nocomb", comb, ac);}
                                }
                        }
                        switch(comb) {
                                case "+":
                                        current.addNextSiblingCombinator();
                                        break;
                                case ">":
                                        current.addChildCombinator();
                                        break;
                                case "~":
                                        current.addSubsequentSiblingCombinator();
                                        break;
                                case "||":
                                        current.addColumnCombinator();
                                        break;
                                case "*none*":
                                        break;
                                default:
                                        current.addDescendantCombinator();
                        }
          break;
          }
        default:
          jj_la1[181] = jj_gen;
          ;
        }
        current = compound_selector(current);
      }
{if ("" != null) return current;}
    } catch (InvalidParamException ie) {
//      skipStatement();
        //      removeThisRule();
                ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                                        getBeginColumn(), getEndLine(), getEndColumn(), ie));
                Token t = getToken(1);
                StringBuilder s = new StringBuilder();
                s.append(getToken(0).image);
                // eat until , { or EOF
                while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
                        s.append(t.image);
                        getNextToken();
                        t = getToken(1);
                }
                {if ("" != null) return null;}
    } catch (ParseException e) {
//      validSelector = false;
                Token t = getToken(1);
                StringBuilder s = new StringBuilder("[");
                s.append(getToken(0).image);
                // eat until , { or EOF
                while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
                        s.append(t.image);
                        getNextToken();
                        t = getToken(1);
                }
                s.append(']');
        //      if (validSelector) {
                addError(e, s.toString());
            //  } else {
            //  addError(e,"");
            //  }
                validSelector = true;
                {if ("" != null) return null;}
    }
    throw new Error("Missing return statement in function");
  }

  final public CssSelectors compound_selector(CssSelectors next) throws ParseException {CssSelectors selector = new CssSelectors(ac, next);
        selector.setAtRule(getAtRule());
    if (jj_2_15(4)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case ANY:
      case 153:{
        type_selector(selector);
        break;
        }
      default:
        jj_la1[182] = jj_gen;
        ;
      }
      label_126:
      while (true) {
        subclass_selector(selector);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case DOT:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:{
          ;
          break;
          }
        default:
          jj_la1[183] = jj_gen;
          break label_126;
        }
      }
      label_127:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PSEUDOELEMENT_SYM:{
          ;
          break;
          }
        default:
          jj_la1[184] = jj_gen;
          break label_127;
        }
        pseudo_element_selector(selector);
        label_128:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COLON:{
            ;
            break;
            }
          default:
            jj_la1[185] = jj_gen;
            break label_128;
          }
          pseudo_class_selector(selector);
        }
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case ANY:
      case 153:{
        type_selector(selector);
        label_129:
        while (true) {
          if (jj_2_11(2)) {
            ;
          } else {
            break label_129;
          }
          pseudo_element_selector(selector);
          label_130:
          while (true) {
            if (jj_2_12(2)) {
              ;
            } else {
              break label_130;
            }
            pseudo_class_selector(selector);
          }
        }
        break;
        }
      case PSEUDOELEMENT_SYM:{
        label_131:
        while (true) {
          pseudo_element_selector(selector);
          label_132:
          while (true) {
            if (jj_2_13(2)) {
              ;
            } else {
              break label_132;
            }
            pseudo_class_selector(selector);
          }
          if (jj_2_14(2)) {
            ;
          } else {
            break label_131;
          }
        }
        break;
        }
      default:
        jj_la1[186] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return selector;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void class_selector(CssSelectors s) throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      n = ident();
try {
            s.addClass(new ClassSelector(convertClassIdent(n.image)));
        } catch (InvalidParamException e) {
            //	    removeThisRule();
             ac.getFrame()
                .addError(new CssError(getSourceFile(), getBeginLine(),
                    getBeginColumn(), getEndLine(), getEndColumn(), e));
            {if (true) throw new ParseException(e.getMessage());}
        }
      break;
      }
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case ANGLE:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:{
      n = deprecated_class();
if (n.image.charAt(0) == '.') {
            n.image = n.image.substring(1);

            // the class with the first digit escaped
            String cl = "."+hexEscapeFirst(n.image);

        CssVersion version = ac.getCssVersion();
//	    String profile = ac.getProfile();
//	    if(profile == null || profile.equals("") || profile.equals("none")) {
//		profile = ac.getCssVersionString();
//	    }

            if(version != CssVersion.CSS1) {
                StringBuilder sb = new StringBuilder();
                ArrayList<String> param_err = new ArrayList<String>(2);
                param_err.add(n.image);
                param_err.add(cl);
                sb.append(ac.getMsg().getString("parser.old_class", param_err));
                {if (true) throw new ParseException(sb.toString());}
                //		s.addClass(new ClassSelector(n.image));                            
                // removeThisRule();              
            }
            else {
                CssLength length = new CssLength();
                boolean isLength = false;
                try {
                    length.set(n.image, ac);
                    isLength = true;
                }
                catch(Exception e) {
                    isLength = false;
                }
                if(isLength) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(ac.getMsg().getString("parser.class_dim"));
                    sb.append(n.image);
                    {if (true) throw new ParseException(sb.toString());}
                    //		    s.addClass(new ClassSelector(n.image));                            
                    // removeThisRule();
                }
                else {
                    try {
                        // for css > 1, we add the rule to have a context, 
                        // and we then remove it
                        s.addClass(new ClassSelector(n.image));
                        ac.getFrame().addWarning("old_class");
                    } catch (InvalidParamException e) {
                        {if (true) throw new ParseException(e.getMessage());}
                        //ac.getFrame().addError(new CssError(e));
                        //removeThisRule();
                    }
                }
            }
        } else {
            {if (true) throw new ParseException("Unrecognized ");}
        }
      break;
      }
    default:
      jj_la1[187] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Token deprecated_class() throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RELFONTLENGTH:{
      n = jj_consume_token(RELFONTLENGTH);
      break;
      }
    case RELVIEWLENGTH:{
      n = jj_consume_token(RELVIEWLENGTH);
      break;
      }
    case ABSOLUTLENGTH:{
      n = jj_consume_token(ABSOLUTLENGTH);
      break;
      }
    case ANGLE:{
      n = jj_consume_token(ANGLE);
      break;
      }
    case TIME:{
      n = jj_consume_token(TIME);
      break;
      }
    case FREQ:{
      n = jj_consume_token(FREQ);
      break;
      }
    case RESOLUTION:{
      n = jj_consume_token(RESOLUTION);
      break;
      }
    case DIMEN:{
      n = jj_consume_token(DIMEN);
      break;
      }
    default:
      jj_la1[188] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void type_selector(CssSelectors s) throws ParseException {Token n=null;
    Token p=null;
    String prefix = null;
    if (jj_2_16(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case ANY:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:{
          n = ident();
          break;
          }
        case ANY:{
          n = jj_consume_token(ANY);
          break;
          }
        default:
          jj_la1[189] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[190] = jj_gen;
        ;
      }
      p = jj_consume_token(153);
    } else {
      ;
    }
// FIXME namespace, check versions of CSS in a better way.
        if (p != null) {
            // FIXME should be > CSS3
            if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                StringBuilder sb = new StringBuilder("namespace \"");
                if (n != null) sb.append(n.toString());
                sb.append("\"");
                ac.getFrame()
                   .addError(new CssError(getSourceFile(), getBeginLine(),
                       getBeginColumn(), getEndLine(), getEndColumn(),
                           new InvalidParamException("notversion",
                               sb.toString(), ac.getCssVersionString(), ac)));
                removeThisRule();
            } else if (n!=null) {
                prefix = convertIdent(n.image);
                if (!ac.isNamespaceDefined(getURL(), prefix)) {
                    // ns is not defined
                    addError(new ParseException("Undefined namespace"),
                             ": The namespace \""+prefix
                             +"\" is not defined. "
                             + prefix );
                    removeThisRule();
                }
            } else {
                prefix = "";
            }
        }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:{
      n = ident();
//              s.setElement(convertIdent(n.image), ac);
        s.addType(new TypeSelector(prefix, convertIdent(n.image)));
      break;
      }
    case ANY:{
      jj_consume_token(ANY);
if (ac.getCssVersion() != CssVersion.CSS1) {
            //          s.setElement(null);
            s.addUniversal(new UniversalSelector(prefix));
        } else {
            ac.getFrame()
               .addError(new CssError(getSourceFile(), getBeginLine(),
                   getBeginColumn(), getEndLine(), getEndColumn(),
                       new InvalidParamException("notversion", "*",
                           ac.getCssVersionString(), ac)));
        }
      break;
      }
    default:
      jj_la1[191] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void attribute_selector(CssSelectors s) throws ParseException {Token att = null;
    Token val = null;
    Token mod = null;
    Token pre = null;
    int selectorType = CssSelectors.ATTRIBUTE_ANY;
    jj_consume_token(LBRACKET);
    label_133:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[192] = jj_gen;
        break label_133;
      }
      jj_consume_token(S);
    }
    if (jj_2_17(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:
      case ANY:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:{
          pre = ident();
          break;
          }
        case ANY:{
          pre = jj_consume_token(ANY);
          break;
          }
        default:
          jj_la1[193] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[194] = jj_gen;
        ;
      }
      jj_consume_token(153);
    } else {
      ;
    }
    att = ident();
    label_134:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[195] = jj_gen;
        break label_134;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INCLUDES:
    case DASHMATCH:
    case PREFIXMATCH:
    case SUFFIXMATCH:
    case SUBSTRINGMATCH:
    case EQ:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
selectorType = CssSelectors.ATTRIBUTE_EXACT;
        break;
        }
      case INCLUDES:{
        jj_consume_token(INCLUDES);
selectorType = CssSelectors.ATTRIBUTE_ONE_OF;
        break;
        }
      case DASHMATCH:{
        jj_consume_token(DASHMATCH);
selectorType = CssSelectors.ATTRIBUTE_BEGIN;
        break;
        }
      case PREFIXMATCH:{
        jj_consume_token(PREFIXMATCH);
selectorType = CssSelectors.ATTRIBUTE_START;
        break;
        }
      case SUFFIXMATCH:{
        jj_consume_token(SUFFIXMATCH);
selectorType = CssSelectors.ATTRIBUTE_SUFFIX;
        break;
        }
      case SUBSTRINGMATCH:{
        jj_consume_token(SUBSTRINGMATCH);
selectorType = CssSelectors.ATTRIBUTE_SUBSTR;
        break;
        }
      default:
        jj_la1[196] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_135:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[197] = jj_gen;
          break label_135;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        val = ident();
val.image = convertIdent(val.image);
        break;
        }
      case STRING:{
        val = jj_consume_token(STRING);
val.image = convertStringIndex(val.image, 1, val.image.length() -1, false);
        break;
        }
      default:
        jj_la1[198] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_18(2)) {
        label_136:
        while (true) {
          jj_consume_token(S);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[199] = jj_gen;
            break label_136;
          }
        }
        mod = ident();
      } else {
        ;
      }
      label_137:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[200] = jj_gen;
          break label_137;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[201] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
if (ac.getCssVersion() == CssVersion.CSS1) {
                StringBuilder reason;
                CssParseException cp;
                ParseException p;
                reason = new StringBuilder(" [");
                if (att != null) {
                        reason.append(convertIdent(att.image));
                }
                if (val != null ) {
                        reason.append('=').append(val.image);
                }
                reason.append(']');
                p = new ParseException(ac.getMsg().getString("parser.attrcss1")+
                                        reason.toString());
                cp = new CssParseException(p);
                ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                        getBeginColumn(), getEndLine(), getEndColumn(), cp));
                removeThisRule();
        }
        if ((mod != null) && ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                String reason = mod.image;
                ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                        getBeginColumn(), getEndLine(), getEndColumn(),
                                        new InvalidParamException("notversion",
                                        reason, ac.getCssVersionString(), ac)));

                removeThisRule();
        }
        if ((pre != null) && ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                StringBuilder sb = new StringBuilder("namespace \"").append(pre.image).append('"');
                ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                        getBeginColumn(), getEndLine(), getEndColumn(),
                                        new InvalidParamException("notversion",
                                        sb.toString(), ac.getCssVersionString(), ac)));
                removeThisRule();
        }
        if (selectorType == CssSelectors.ATTRIBUTE_ANY) {
                try {
                        AttributeSelector as;
                        as = new AttributeAny(att.image.toLowerCase());
                        if (pre != null) {
                                as.setPrefix(pre.image);
                        }
                        if (mod != null) {
                                as.setModifier(mod.image, ac);
                        }
                        s.addAttribute(as);
//                      s.addAttribute(att.image.toLowerCase(), null, selectorType);
                } catch (InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                                getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        } else {
                AttributeSelector attribute;
                switch(selectorType) {
                        case CssSelectors.ATTRIBUTE_BEGIN:
                                attribute = new AttributeBegin(att.image.toLowerCase(), val.image);
                                break;
                        case CssSelectors.ATTRIBUTE_EXACT:
                                attribute = new AttributeExact(att.image.toLowerCase(), val.image);
                                break;
                        case CssSelectors.ATTRIBUTE_ONE_OF:
                                attribute = new AttributeOneOf(ac, att.image.toLowerCase(), val.image);
                                break;
                        case CssSelectors.ATTRIBUTE_START:
                                attribute = new AttributeStart(att.image.toLowerCase(), val.image);
                                break;
                        case CssSelectors.ATTRIBUTE_SUBSTR:
                                attribute = new AttributeSubstr(att.image.toLowerCase(), val.image);
                                break;
                        case CssSelectors.ATTRIBUTE_SUFFIX:
                                attribute = new AttributeSuffix(att.image.toLowerCase(), val.image);
                                break;
                        default:
                                attribute = new AttributeExact(att.image.toLowerCase(), val.image);
                        break;
                }
                try {
                        if (pre != null) {
                                attribute.setPrefix(pre.image);
                        }
                        if (mod != null) {
                                attribute.setModifier(mod.image, ac);
                        }
                        s.addAttribute(attribute);
//	      	  s.addAttribute(att.image.toLowerCase(), val.image, 
//			     selectorType);
                } catch (InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                                getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        }
  }

  final public void pseudo_element_selector(CssSelectors s) throws ParseException {Token n;
        CssSelectors sel = null;
    jj_consume_token(PSEUDOELEMENT_SYM);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:{
      n = ident();
try {
                // should be >CSS3
                        if (ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0) {
                                s.addPseudoElement(convertIdent(n.image).toLowerCase());
                        } else {
                                {if (true) throw new InvalidParamException("pseudo-element",
                                                                "::" + convertIdent(n.image).toLowerCase(),
                                                                ac.getCssVersionString() ,ac);}
                        }
                } catch(InvalidParamException e) {
                        validSelector = false;
                        {if (true) throw new ParseException(e.getMessage());}
                }
      break;
      }
    case FUNCTIONSLOTTED:{
      n = jj_consume_token(FUNCTIONSLOTTED);
      label_138:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[202] = jj_gen;
          break label_138;
        }
        jj_consume_token(S);
      }
      sel = compound_selector(null);
      label_139:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[203] = jj_gen;
          break label_139;
        }
        jj_consume_token(S);
      }
      jj_consume_token(RPAREN);
try {
                        ArrayList<CssSelectors> list = new ArrayList<CssSelectors>();
                        list.add(sel);
                        s.setPseudoFun(ac, convertStringIndex(n.image, 0, n.image.length() -1, false).toLowerCase(), list);
                } catch(InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                                getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
      break;
      }
    default:
      jj_la1[204] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void pseudo(CssSelectors s) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PSEUDOELEMENT_SYM:{
      pseudo_element_selector(s);
      break;
      }
    case COLON:{
      pseudo_class_selector(s);
      break;
      }
    default:
      jj_la1[205] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void pseudo_class_selector(CssSelectors s) throws ParseException {Token n;
Token id = null;
Token language = null;
CssExpression param = null;
ArrayList<CssSelectors> selector_list = null;
CssSelectors sel = null;
String error_str = null;
String prefix = null;
CssExpression exp = new CssExpression();
CssANPlusB anpb = null;
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:{
      n = ident();
try {
                    s.addPseudoClass(convertIdent(n.image).toLowerCase());
                } catch(InvalidParamException e) {
                    removeThisRule();
                    ac.getFrame()
                       .addError(new CssError(getSourceFile(), getBeginLine(),
                           getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
      break;
      }
    case FUNCTIONLANG:
    case FUNCTIONDIR:
    case FUNCTIONIS:
    case FUNCTIONWHERE:
    case FUNCTIONHAS:
    case FUNCTIONHOST:
    case FUNCTIONHOSTCONTEXT:
    case FUNCTIONNTHCHILD:
    case FUNCTIONNTHLASTCHILD:
    case FUNCTIONNTHCOL:
    case FUNCTIONNTHLASTCOL:
    case FUNCTIONNTHOFTYPE:
    case FUNCTIONNTHLASTOFTYPE:
    case FUNCTIONNOT:
    case FUNCTION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FUNCTIONLANG:
      case FUNCTIONDIR:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FUNCTIONDIR:{
          n = jj_consume_token(FUNCTIONDIR);
          break;
          }
        case FUNCTIONLANG:{
          n = jj_consume_token(FUNCTIONLANG);
          break;
          }
        default:
          jj_la1[206] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_140:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[207] = jj_gen;
            break label_140;
          }
          jj_consume_token(S);
        }
        term(exp);
try {
                    s.setPseudoFun(ac, convertStringIndex(n.image, 0, n.image.length() -1, false).toLowerCase(), exp);
                } catch(InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame()
                           .addError(new CssError(getSourceFile(), getBeginLine(),
                               getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        break;
        }
      case FUNCTIONIS:
      case FUNCTIONNOT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FUNCTIONIS:{
          n = jj_consume_token(FUNCTIONIS);
          break;
          }
        case FUNCTIONNOT:{
          n = jj_consume_token(FUNCTIONNOT);
          break;
          }
        default:
          jj_la1[208] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_141:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[209] = jj_gen;
            break label_141;
          }
          jj_consume_token(S);
        }
        selector_list = selector_list();
        label_142:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[210] = jj_gen;
            break label_142;
          }
          jj_consume_token(S);
        }
try {
                        s.setPseudoFun(ac, convertStringIndex(n.image, 0, n.image.length() -1, false).toLowerCase(), selector_list);
                } catch(InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                                getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        break;
        }
      case FUNCTIONWHERE:{
        n = jj_consume_token(FUNCTIONWHERE);
        label_143:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[211] = jj_gen;
            break label_143;
          }
          jj_consume_token(S);
        }
        try {
          selector_list = selector_list();
          label_144:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[212] = jj_gen;
              break label_144;
            }
            jj_consume_token(S);
          }
        } catch (ParseException ignored) {
s.setPseudoFun(ac, convertStringIndex(n.image, 0, n.image.length() -1, false).toLowerCase(),
                                                                skip_to_matching_paren());
        }
try {
                        s.setPseudoFun(ac, convertStringIndex(n.image, 0, n.image.length() -1, false).toLowerCase(), selector_list);
                } catch(InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                                getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        break;
        }
      case FUNCTIONHAS:{
        n = jj_consume_token(FUNCTIONHAS);
        selector_list = relative_selector_list();
        label_145:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[213] = jj_gen;
            break label_145;
          }
          jj_consume_token(S);
        }
try {
                        s.setPseudoFun(ac, convertStringIndex(n.image, 0, n.image.length() -1, false).toLowerCase(), selector_list);
                } catch(InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                                getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        break;
        }
      case FUNCTIONHOST:
      case FUNCTIONHOSTCONTEXT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FUNCTIONHOST:{
          n = jj_consume_token(FUNCTIONHOST);
          break;
          }
        case FUNCTIONHOSTCONTEXT:{
          n = jj_consume_token(FUNCTIONHOSTCONTEXT);
          break;
          }
        default:
          jj_la1[214] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_146:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[215] = jj_gen;
            break label_146;
          }
          jj_consume_token(S);
        }
        sel = compound_selector(null);
        label_147:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[216] = jj_gen;
            break label_147;
          }
          jj_consume_token(S);
        }
try {
                        ArrayList<CssSelectors> list = new ArrayList<CssSelectors>();
                        list.add(sel);
                        s.setPseudoFun(ac, convertStringIndex(n.image, 0, n.image.length() -1, false).toLowerCase(), list);
                } catch(InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                                getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        break;
        }
      case FUNCTIONNTHCHILD:
      case FUNCTIONNTHLASTCHILD:
      case FUNCTIONNTHOFTYPE:
      case FUNCTIONNTHLASTOFTYPE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FUNCTIONNTHCHILD:{
          n = jj_consume_token(FUNCTIONNTHCHILD);
          break;
          }
        case FUNCTIONNTHLASTCHILD:{
          n = jj_consume_token(FUNCTIONNTHLASTCHILD);
          break;
          }
        case FUNCTIONNTHOFTYPE:{
          n = jj_consume_token(FUNCTIONNTHOFTYPE);
          break;
          }
        case FUNCTIONNTHLASTOFTYPE:{
          n = jj_consume_token(FUNCTIONNTHLASTOFTYPE);
          break;
          }
        default:
          jj_la1[217] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_148:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[218] = jj_gen;
            break label_148;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case AN:
        case DIMEN:
        case NUMBER:{
          anpb = anplusb();
          label_149:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[219] = jj_gen;
              break label_149;
            }
            jj_consume_token(S);
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AND:
          case OR:
          case ONLY:
          case NOT:
          case IDENT:{
            id = ident();
            label_150:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[220] = jj_gen;
                break label_150;
              }
              jj_consume_token(S);
            }
            selector_list = selector_list();
            label_151:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                ;
                break;
                }
              default:
                jj_la1[221] = jj_gen;
                break label_151;
              }
              jj_consume_token(S);
            }
            break;
            }
          default:
            jj_la1[222] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[223] = jj_gen;
          error_str = skip_to_matching_paren();
        }
try {
                        exp.addValue(anpb);
                        if (id != null) {
                                setValue(new CssIdent(), exp, ' ', id, IDENT);
                        }
                        s.setPseudoFun(ac, convertStringIndex(n.image, 0, n.image.length() -1, false).toLowerCase(), exp, selector_list);
                } catch(InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                                getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        break;
        }
      case FUNCTIONNTHCOL:
      case FUNCTIONNTHLASTCOL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FUNCTIONNTHCOL:{
          n = jj_consume_token(FUNCTIONNTHCOL);
          break;
          }
        case FUNCTIONNTHLASTCOL:{
          n = jj_consume_token(FUNCTIONNTHLASTCOL);
          break;
          }
        default:
          jj_la1[224] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_152:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[225] = jj_gen;
            break label_152;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:
        case AND:
        case OR:
        case ONLY:
        case NOT:
        case IDENT:
        case AN:
        case DIMEN:
        case NUMBER:{
          anpb = anplusb();
          label_153:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[226] = jj_gen;
              break label_153;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[227] = jj_gen;
          error_str = skip_to_matching_paren();
        }
try {
                        exp.addValue(anpb);
                        s.setPseudoFun(ac, convertStringIndex(n.image, 0, n.image.length() -1, false).toLowerCase(), exp);
                } catch(InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame().addError(new CssError(getSourceFile(), getBeginLine(),
                                                getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        break;
        }
      case FUNCTION:{
        n = jj_consume_token(FUNCTION);
        label_154:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[228] = jj_gen;
            break label_154;
          }
          jj_consume_token(S);
        }
        param = expression();
try {
                    s.setPseudoFun(ac, convertStringIndex(n.image, 0, n.image.length() -1, false).toLowerCase(),
                                   param.toString());
                } catch(InvalidParamException e) {
                    removeThisRule();
                    ac.getFrame()
                       .addError(new CssError(getSourceFile(), getBeginLine(),
                           getBeginColumn(), getEndLine(), getEndColumn(), e));
                }
        break;
        }
      default:
        jj_la1[229] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[230] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void id_selector(CssSelectors s) throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HASHIDENT:{
      n = jj_consume_token(HASHIDENT);
n.image = n.image.substring(1);
      if(Character.isDigit(n.image.charAt(0))) {

      CssVersion version = ac.getCssVersion();

      if (version != CssVersion.CSS1) {
              // the id with the first digit escaped
              String cl = "\\" + Integer.toString(n.image.charAt(0), 16);
              cl += n.image.substring(1);

              addError(new ParseException(ac.getMsg().getString(
                "parser.old_id")),
                "To make \"." + n.image + "\" a valid id, CSS2" +
                " requires the first digit to be escaped " +
                "(\"#" + cl + "\")");
              // for css > 1, we add the rule to have a context, 
              // and we then remove it
              s.addId(new IdSelector(n.image));
              removeThisRule();
          }
          else {
              CssLength length = new CssLength();
              boolean isLength = false;
              try {
                  length.set(n.image, ac);
                  isLength = true;
              }
              catch(Exception e) {
                  isLength = false;
              }
              if(isLength) {
                  addError(new ParseException(ac.getMsg().getString(
                  "parser.id_dim")), n.image);
                  // we add the rule to have a context, and then we remove it
                  s.addId(new IdSelector(n.image));
                  removeThisRule();
              }
              else {
                  try {
                      s.addId(new IdSelector(n.image));
                      ac.getFrame().addWarning("old_id");
                  } catch (InvalidParamException e) {
                      ac.getFrame()
                         .addError(new CssError(getSourceFile(), getBeginLine(),
                             getBeginColumn(), getEndLine(), getEndColumn(), e));
                      removeThisRule();
                  }
              }
          }
      }
      else {
          try {
              s.addId(new IdSelector(n.image));
          } catch (InvalidParamException e) {
              ac.getFrame()
                 .addError(new CssError(getSourceFile(), getBeginLine(),
                     getBeginColumn(), getEndLine(), getEndColumn(), e));
              removeThisRule();
          }
      }
      break;
      }
    case HASH:{
      n = jj_consume_token(HASH);
{if (true) throw new ParseException(ac.getMsg().getString("parser.invalid_id_selector"));}
      break;
      }
    default:
      jj_la1[231] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssProperty mediadeclaration() throws ParseException {String string_property;
  CssExpression values = null;
  boolean important = false;
  setMediaDeclaration(true);
    try {
      string_property = property();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        label_155:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[232] = jj_gen;
            break label_155;
          }
          jj_consume_token(S);
        }
        values = expr();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IMPORTANT_SYM:{
          important = prio();
          break;
          }
        default:
          jj_la1[233] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[234] = jj_gen;
        ;
      }
try {
            if ( string_property == null) { // hack return code
                {if ("" != null) return null;}
            }
            setImportant(important);

            if (incompatible_error) {
                {if (true) throw new InvalidParamException("notforcss1", "inherit", ac);}
            }

            CssProperty p = handleDeclaration(string_property.toLowerCase(),
                                                  values, important);
            {if ("" != null) return p;}

        } catch (InvalidParamException e) {
                incompatible_error = false;
                if (null != values) {
                        values.starts();
                }
                addError(e, (CssExpression) values);
        }
        {if ("" != null) return null;}
    } catch (NumberFormatException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } catch (ParseException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } finally {
setMediaDeclaration(false);
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssProperty declaration() throws ParseException {String string_property;
  CssExpression values = null;
  boolean important = false;
    try {
      string_property = property();
      jj_consume_token(COLON);
      label_156:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[235] = jj_gen;
          break label_156;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case STRING:
      case IDENT:
      case HASHIDENT:
      case HASH:
      case PROGID:
      case DIV:
      case LBRACKET:
      case RBRACKET:
      case URL:
      case RELFONTLENGTH:
      case RELVIEWLENGTH:
      case ABSOLUTLENGTH:
      case FLEX:
      case ANGLE:
      case SPL:
      case ST:
      case TIME:
      case FREQ:
      case RESOLUTION:
      case DIMEN_9:
      case DIMEN:
      case PERCENTAGE:
      case NUMBER:
      case IMPORTANT_NOT:
      case UNICODERANGE:
      case FUNCTIONCALC:
      case FUNCTIONMATHN:
      case FUNCTIONMATH1:
      case FUNCTIONMATH2:
      case FUNCTIONROUND:
      case FUNCTIONCLAMP:
      case FUNCTIONATTR:
      case FUNCTIONVAR:
      case FUNCTION:{
        values = expr();
        break;
        }
      default:
        jj_la1[236] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPORTANT_SYM:{
        important = prio();
        break;
        }
      default:
        jj_la1[237] = jj_gen;
        ;
      }
try {
            if (string_property == null) {
              {if ("" != null) return null;}
            }
            setImportant(important);

            if (incompatible_error) {
                {if (true) throw new InvalidParamException("notforcss1", "inherit", ac);}
            }
            if (values == null) {
                if (string_property.startsWith("--")) {
                        values = new CssExpression();
                } else {
                        // old behaviour for empty properties
                        {if (true) throw new ParseException();}
                }
            }
            if (values.getCount() != 0 || string_property.startsWith("--")) {
                CssProperty p = handleDeclaration(string_property.toLowerCase(),
                                                  values, important);
                // Did the property recognize all values in the expression ?

                if (!values.end() && ac.getMedium() == null) {
                   addError(new InvalidParamException("unrecognize", "", ac),
                             values);
                } else {
                    // ok, return the new property
                    {if ("" != null) return p;}
                }
            }
        } catch (InvalidParamException e) {
            incompatible_error = false;
            if (e instanceof WarningParamException) {
                WarningParamException warningException =
                    (WarningParamException) e;
                ac.getFrame().addWarning(warningException.getMessage(),
                                         warningException.getMessageArgs());
            } else {
                values.starts();
                addError(e, (CssExpression) values);
            }
        }
        {if ("" != null) return null;}
    } catch (NumberFormatException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } catch (ParseException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } catch (NullPointerException e) {
// NullPointerException happen if in handling a property
        // something bad happen (like setting values on sub properties
        // that had not been initialized (for an unknown reason yet).
     skipAfterExpression(e);
     {if ("" != null) return null;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_157:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[238] = jj_gen;
        break label_157;
      }
      jj_consume_token(S);
    }
{if ("" != null) return true;}
    throw new Error("Missing return statement in function");
  }

  final public CssExpression expression() throws ParseException {CssExpression exp = new CssExpression();
    char operator = ' ';
    Token n = null;
    label_158:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
operator = '+' ;
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
operator = '-';
        break;
        }
      case NUMBER:{
        n = jj_consume_token(NUMBER);
setValue(new CssNumber(), exp, operator, n, NUMBER);
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
setValue(new CssPercentage(), exp, operator, n, PERCENTAGE);
        break;
        }
      case DIMEN:{
        n = jj_consume_token(DIMEN);
setValue(new CssIdent(), exp, operator, n, IDENT);
        break;
        }
      case STRING:{
        n = jj_consume_token(STRING);
setValue(new CssString(), exp, operator, n, STRING);
        break;
        }
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
setValue(new CssIdent(), exp, operator, n, IDENT);
        break;
        }
      default:
        jj_la1[239] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_159:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[240] = jj_gen;
          break label_159;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case STRING:
      case IDENT:
      case DIMEN:
      case PERCENTAGE:
      case NUMBER:{
        ;
        break;
        }
      default:
        jj_la1[241] = jj_gen;
        break label_158;
      }
    }
{if ("" != null) return exp;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssExpression expr() throws ParseException {CssExpression values = new CssExpression();
    try {
      term(values);
      label_160:
      while (true) {
        if (jj_2_19(2)) {
          ;
        } else {
          break label_160;
        }
        operator(values);
        term(values);
      }
    } catch (WarningParamException e) {
ac.getFrame().addWarning(e.getMessage(), e.getMessageArgs());
    }
{if ("" != null) return values;}
    throw new Error("Missing return statement in function");
  }

  final public void mediarange(AtRuleMedia mediaRule, boolean defaultMedia, String combinator) throws ParseException {Token n;
  Token c1 = null;
  Token c2 = null;
  CssValue func;
  String mediaFeatureName;
  CssExpression val1 = null;
  CssExpression val2 = null;
  CssComparator comp1 = null;
  CssComparator comp2 = null;
  boolean nameIsFirst = false;
    jj_consume_token(LPAREN);
    label_161:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[242] = jj_gen;
        break label_161;
      }
      jj_consume_token(S);
    }
    if (jj_2_20(3)) {
      n = ident();
nameIsFirst = true;
      label_162:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[243] = jj_gen;
          break label_162;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case GREATER:{
        c1 = jj_consume_token(GREATER);
        break;
        }
      case GREATEREQ:{
        c1 = jj_consume_token(GREATEREQ);
        break;
        }
      case EQ:{
        c1 = jj_consume_token(EQ);
        break;
        }
      case 152:{
        c1 = jj_consume_token(152);
        break;
        }
      case 154:{
        c1 = jj_consume_token(154);
        break;
        }
      default:
        jj_la1[244] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_163:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[245] = jj_gen;
          break label_163;
        }
        jj_consume_token(S);
      }
      val1 = mediaexpr();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case STRING:
      case IDENT:
      case HASHIDENT:
      case HASH:
      case URL:
      case RELFONTLENGTH:
      case RELVIEWLENGTH:
      case ABSOLUTLENGTH:
      case FLEX:
      case ANGLE:
      case SPL:
      case ST:
      case TIME:
      case FREQ:
      case RESOLUTION:
      case DIMEN_9:
      case DIMEN:
      case PERCENTAGE:
      case NUMBER:
      case IMPORTANT_NOT:
      case UNICODERANGE:
      case FUNCTIONCALC:
      case FUNCTIONMATHN:
      case FUNCTIONMATH1:
      case FUNCTIONMATH2:
      case FUNCTIONROUND:
      case FUNCTIONCLAMP:
      case FUNCTION:{
        val1 = mediaexpr();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case GREATER:{
          c1 = jj_consume_token(GREATER);
          break;
          }
        case GREATEREQ:{
          c1 = jj_consume_token(GREATEREQ);
          break;
          }
        case EQ:{
          c1 = jj_consume_token(EQ);
          break;
          }
        case 152:{
          c1 = jj_consume_token(152);
          break;
          }
        case 154:{
          c1 = jj_consume_token(154);
          break;
          }
        default:
          jj_la1[246] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_164:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[247] = jj_gen;
            break label_164;
          }
          jj_consume_token(S);
        }
        n = ident();
        label_165:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[248] = jj_gen;
            break label_165;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case GREATER:
        case GREATEREQ:
        case EQ:
        case 152:
        case 154:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case GREATER:{
            c2 = jj_consume_token(GREATER);
            break;
            }
          case GREATEREQ:{
            c2 = jj_consume_token(GREATEREQ);
            break;
            }
          case EQ:{
            c2 = jj_consume_token(EQ);
            break;
            }
          case 152:{
            c2 = jj_consume_token(152);
            break;
            }
          case 154:{
            c2 = jj_consume_token(154);
            break;
            }
          default:
            jj_la1[249] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_166:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[250] = jj_gen;
              break label_166;
            }
            jj_consume_token(S);
          }
          val2 = mediaexpr();
          break;
          }
        default:
          jj_la1[251] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[252] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
    label_167:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[253] = jj_gen;
        break label_167;
      }
      jj_consume_token(S);
    }
if (defaultMedia) {
            mediaRule.addMedia(null, null, ac);
          }
          mediaFeatureName = convertIdent(n.image);
          // c1 should always be not null.
          if (c1 != null) {
              comp1 = new CssComparator();
              comp1.set(c1.image, val1, ac);
          }
          if (c2 != null) {
              comp2 = new CssComparator();
              comp2.set(c2.image, val2, ac);
          }
          // we construct a fake one that starts with comparator then expression (doubled if necessary)
          CssExpression nex = new CssExpression();
          nex.addValue(comp1);
          if (comp2 != null) {
              nex.addValue(comp2);
          }
          MediaFeature mf = handleMediaFeature(mediaRule, mediaFeatureName, nex);
          ((MediaRangeFeature)mf).comparatorNameFirst = nameIsFirst;
          if (mf != null) {
              mediaRule.addMediaFeature(mf, ac);
              mf.setCombinator(combinator);
            // mf.setParens();
          }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssExpression mediaexpr() throws ParseException {CssExpression values = new CssExpression();
    mediaterm(values);
    label_168:
    while (true) {
      if (jj_2_21(2)) {
        ;
      } else {
        break label_168;
      }
      operator(values);
      mediaterm(values);
    }
{if ("" != null) return values;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void term(CssExpression exp) throws ParseException {Token n;
  char operator = ' ';
  CssValue func;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case PROGID:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case FLEX:
    case ANGLE:
    case SPL:
    case ST:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN_9:
    case DIMEN:
    case PERCENTAGE:
    case NUMBER:
    case IMPORTANT_NOT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        operator = unaryOperator();
        break;
        }
      default:
        jj_la1[254] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        n = jj_consume_token(NUMBER);
setValue(new CssNumber(), exp, operator, n, NUMBER);
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
setValue(new CssPercentage(), exp, operator, n, PERCENTAGE);
        break;
        }
      case RELFONTLENGTH:{
        n = jj_consume_token(RELFONTLENGTH);
setValue(new CssLength(), exp, operator, n, RELFONTLENGTH);
        break;
        }
      case RELVIEWLENGTH:{
        n = jj_consume_token(RELVIEWLENGTH);
setValue(new CssLength(), exp, operator, n, RELVIEWLENGTH);
        break;
        }
      case ABSOLUTLENGTH:{
        n = jj_consume_token(ABSOLUTLENGTH);
setValue(new CssLength(), exp, operator, n, ABSOLUTLENGTH);
        break;
        }
      case FLEX:{
        n = jj_consume_token(FLEX);
setValue(new CssFlexibleLength(), exp, operator, n, FLEX);
        break;
        }
      case ANGLE:{
        n = jj_consume_token(ANGLE);
setValue(new CssAngle(), exp, operator, n, ANGLE);
        break;
        }
      case TIME:{
        n = jj_consume_token(TIME);
setValue(new CssTime(), exp, operator, n, TIME);
        break;
        }
      case FREQ:{
        n = jj_consume_token(FREQ);
setValue(new CssFrequency(), exp, operator, n, FREQ);
        break;
        }
      case RESOLUTION:{
        n = jj_consume_token(RESOLUTION);
setValue(new CssResolution(), exp, operator, n, RESOLUTION);
        break;
        }
      case ST:{
        n = jj_consume_token(ST);
setValue(new CssSemitone(), exp, operator, n, ST);
        break;
        }
      case SPL:{
        n = jj_consume_token(SPL);
setValue(new CssVolume(), exp, operator, n, SPL);
        break;
        }
      case DIMEN:{
        n = jj_consume_token(DIMEN);
String dimen = n.image.trim();
            if ("0\\0".equals(dimen) && ac.getTreatCssHacksAsWarnings()) {
                exp.markCssHack();
                ac.getFrame().addWarning("css-hack", dimen);
            } else {
                addError(new ParseException(ac.getMsg().getString("parser.unknown-dimension")), dimen);
            }
        break;
        }
      case PROGID:{
        n = jj_consume_token(PROGID);
if (ac.getTreatVendorExtensionsAsWarnings()) {
                 {if (true) throw new WarningParamException("vendor-extension", n.image);}
             } else {
                 {if (true) throw new ParseException(String.format(ac.getMsg()
                         .getString("warning.vendor-extension"), n.image));}
             }
        break;
        }
      case IMPORTANT_NOT:{
        n = jj_consume_token(IMPORTANT_NOT);
if (ac.getTreatCssHacksAsWarnings()) {
               {if (true) throw new WarningParamException("css-hack", n.image.trim());}
           } else {
               {if (true) throw new ParseException(String.format(ac.getMsg()
                       .getString("warning.css-hack"), n.image.trim()));}
           }
        break;
        }
      case DIMEN_9:{
        n = jj_consume_token(DIMEN_9);
if (ac.getTreatCssHacksAsWarnings()) {
                ac.getFrame().addWarning("css-hack", n.image.trim());
                exp.markCssHack();
            } else {
                addError(new ParseException(ac.getMsg().getString("parser.unknown-dimension")), n.image);
            }
        break;
        }
      default:
        jj_la1[255] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case STRING:
    case IDENT:
    case HASHIDENT:
    case HASH:
    case DIV:
    case LBRACKET:
    case RBRACKET:
    case URL:
    case UNICODERANGE:
    case FUNCTIONCALC:
    case FUNCTIONMATHN:
    case FUNCTIONMATH1:
    case FUNCTIONMATH2:
    case FUNCTIONROUND:
    case FUNCTIONCLAMP:
    case FUNCTIONATTR:
    case FUNCTIONVAR:
    case FUNCTION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FUNCTIONCALC:{
        func = mathcalc();
setValue(func, exp, operator, null, FUNCTIONCALC);
        break;
        }
      case FUNCTIONMATHN:
      case FUNCTIONMATH1:
      case FUNCTIONMATH2:
      case FUNCTIONROUND:{
        func = mathfunction();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case FUNCTIONCLAMP:{
        func = mathclamp();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case FUNCTIONATTR:{
        func = attr();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case FUNCTIONVAR:{
        func = functionvar();
setValue(func, exp, operator, null, FUNCTIONVAR);
        break;
        }
      case FUNCTION:{
        func = function();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case STRING:{
        n = jj_consume_token(STRING);
setValue(new CssString(), exp, operator, n, STRING);
        break;
        }
      case DIV:{
        n = jj_consume_token(DIV);
setValue(new CssSwitch(), exp, operator, n, DIV);
        break;
        }
      case LBRACKET:
      case RBRACKET:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case RBRACKET:{
          n = jj_consume_token(RBRACKET);
          break;
          }
        case LBRACKET:{
          n = jj_consume_token(LBRACKET);
          break;
          }
        default:
          jj_la1[256] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
setValue(new CssBracket(), exp, operator, n, RBRACKET);
        break;
        }
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
/*
	 * Common error :
	 * H1 {
	 *   color : black
	 *   background : white
	 * }
	 */
            Token t = getToken(1);
            Token semicolon = new Token();
            semicolon.kind = SEMICOLON;
            semicolon.image = ";";
            if (t.kind == COLON) {
                /* @@SEEME. (generate a warning?) */
                /* @@SEEME if expression is a single ident, 
		   generate an error ? */
                addError(new ParseException(String.format(ac.getMsg().getString("parser.semi-colon"), n)),
                         (CssExpression) null);
                rejectToken(semicolon);
            } else {
                setValue(new CssIdent(), exp, operator, n, IDENT);
            }
        break;
        }
      case HASHIDENT:
      case HASH:{
        hashident(exp);
        break;
        }
      case URL:{
        n = jj_consume_token(URL);
CssURL _u = new CssURL();
            _u.set(n.image, ac, url);
            exp.addValue(_u);
        break;
        }
      case UNICODERANGE:{
        n = jj_consume_token(UNICODERANGE);
setValue(new CssUnicodeRange(), exp, operator, n, UNICODERANGE);
        break;
        }
      default:
        jj_la1[257] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[258] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_169:
    while (true) {
      if (jj_2_22(2)) {
        ;
      } else {
        break label_169;
      }
      jj_consume_token(S);
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void mediaterm(CssExpression exp) throws ParseException {Token n;
  char operator = ' ';
  CssValue func;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case FLEX:
    case ANGLE:
    case SPL:
    case ST:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN_9:
    case DIMEN:
    case PERCENTAGE:
    case NUMBER:
    case IMPORTANT_NOT:
    case FUNCTIONCALC:
    case FUNCTIONMATHN:
    case FUNCTIONMATH1:
    case FUNCTIONMATH2:
    case FUNCTIONROUND:
    case FUNCTIONCLAMP:
    case FUNCTION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        operator = unaryOperator();
        break;
        }
      default:
        jj_la1[259] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        if (jj_2_23(2147483647)) {
          ratio(exp, operator);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NUMBER:{
            n = jj_consume_token(NUMBER);
setValue(new CssNumber(), exp, operator, n, NUMBER);
            break;
            }
          default:
            jj_la1[260] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
setValue(new CssPercentage(), exp, operator, n,
                                PERCENTAGE);
        break;
        }
      case RELFONTLENGTH:{
        n = jj_consume_token(RELFONTLENGTH);
setValue(new CssLength(), exp, operator, n, RELFONTLENGTH);
        break;
        }
      case RELVIEWLENGTH:{
        n = jj_consume_token(RELVIEWLENGTH);
setValue(new CssLength(), exp, operator, n, RELVIEWLENGTH);
        break;
        }
      case ABSOLUTLENGTH:{
        n = jj_consume_token(ABSOLUTLENGTH);
setValue(new CssLength(), exp, operator, n, ABSOLUTLENGTH);
        break;
        }
      case FLEX:{
        n = jj_consume_token(FLEX);
setValue(new CssFlexibleLength(), exp, operator, n, FLEX);
        break;
        }
      case ANGLE:{
        n = jj_consume_token(ANGLE);
setValue(new CssAngle(), exp, operator, n, ANGLE);
        break;
        }
      case TIME:{
        n = jj_consume_token(TIME);
setValue(new CssTime(), exp, operator, n, TIME);
        break;
        }
      case FREQ:{
        n = jj_consume_token(FREQ);
setValue(new CssFrequency(), exp, operator, n, FREQ);
        break;
        }
      case RESOLUTION:{
        n = jj_consume_token(RESOLUTION);
setValue(new CssResolution(), exp, operator, n, RESOLUTION);
        break;
        }
      case ST:{
        n = jj_consume_token(ST);
setValue(new CssSemitone(), exp, operator, n, ST);
        break;
        }
      case SPL:{
        n = jj_consume_token(SPL);
setValue(new CssVolume(), exp, operator, n, SPL);
        break;
        }
      case DIMEN:{
        n = jj_consume_token(DIMEN);
String dimen = n.image.trim();
          if ("0\\0".equals(dimen) && ac.getTreatCssHacksAsWarnings()) {
              exp.markCssHack();
              ac.getFrame().addWarning("css-hack", dimen);
          } else {
              addError(new ParseException(ac.getMsg().getString("parser.unknown-dimension")), dimen);
          }
        break;
        }
      case IMPORTANT_NOT:{
        n = jj_consume_token(IMPORTANT_NOT);
if (ac.getTreatCssHacksAsWarnings()) {
           {if (true) throw new WarningParamException("css-hack", n.image.trim());}
       } else {
           {if (true) throw new ParseException(String.format(ac.getMsg()
                   .getString("warning.css-hack"), n.image.trim()));}
       }
        break;
        }
      case DIMEN_9:{
        n = jj_consume_token(DIMEN_9);
if (ac.getTreatCssHacksAsWarnings()) {
                exp.markCssHack();
                ac.getFrame().addWarning("css-hack", n.image.trim());
            } else {
                addError(new ParseException(ac.getMsg().getString("parser.unknown-dimension")), n.image.trim());
            }
        break;
        }
      case FUNCTIONCALC:
      case FUNCTIONMATHN:
      case FUNCTIONMATH1:
      case FUNCTIONMATH2:
      case FUNCTIONROUND:
      case FUNCTIONCLAMP:
      case FUNCTION:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FUNCTION:{
          func = function();
setValue(func, exp, operator, null, FUNCTION);
          break;
          }
        case FUNCTIONCALC:{
          func = mathcalc();
setValue(func, exp, operator, null, FUNCTIONCALC);
          break;
          }
        case FUNCTIONMATHN:
        case FUNCTIONMATH1:
        case FUNCTIONMATH2:
        case FUNCTIONROUND:{
          func = mathfunction();
setValue(func, exp, operator, null, FUNCTION);
          break;
          }
        case FUNCTIONCLAMP:{
          func = mathclamp();
setValue(func, exp, operator, null, FUNCTION);
          break;
          }
        default:
          jj_la1[261] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[262] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_170:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[263] = jj_gen;
          break label_170;
        }
        jj_consume_token(S);
      }
      break;
      }
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case STRING:
    case IDENT:
    case HASHIDENT:
    case HASH:
    case URL:
    case UNICODERANGE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING:{
        n = jj_consume_token(STRING);
setValue(new CssString(), exp, operator, n, STRING);
        break;
        }
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
/*
	 * Common error :
	 * H1 {
	 *   color : black
	 *   background : white
	 * }
	 */
        Token t = getToken(1);
        Token semicolon = new Token();
        semicolon.kind = SEMICOLON;
        semicolon.image = ";";
        if (t.kind == COLON) {
            /* @@SEEME. (generate a warning?) */
            /* @@SEEME if expression is a single ident,
	       generate an error ? */
            addError(new ParseException(String.format(ac.getMsg().getString("parser.semi-colon"), n)),
                     (CssExpression) null);
            rejectToken(semicolon);
        } else {
            setValue(new CssIdent(), exp, operator, n, IDENT);
        }
        break;
        }
      case HASHIDENT:
      case HASH:{
        hashident(exp);
        break;
        }
      case URL:{
        n = jj_consume_token(URL);
CssURL _u = new CssURL();
        _u.set(n.image, ac, url);
        exp.addValue(_u);
        break;
        }
      case UNICODERANGE:{
        n = jj_consume_token(UNICODERANGE);
setValue(new CssUnicodeRange(), exp, operator, n,
                                UNICODERANGE);
        break;
        }
      default:
        jj_la1[264] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_171:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[265] = jj_gen;
          break label_171;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[266] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public CssCheckableValue mathfunction() throws ParseException {CssCheckableValue v;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FUNCTIONMATH1:{
      v = mathfunction1();
      break;
      }
    case FUNCTIONMATH2:{
      v = mathfunction2();
      break;
      }
    case FUNCTIONMATHN:{
      v = mathfunctionn();
      break;
      }
    case FUNCTIONROUND:{
      v = mathfunctionround();
      break;
      }
    default:
      jj_la1[267] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return v;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathfunctionn() throws ParseException {CssCheckableValue v;
    CssMathFunction c;
    Token n;
    n = jj_consume_token(FUNCTIONMATHN);
    label_172:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[268] = jj_gen;
        break label_172;
      }
      jj_consume_token(S);
    }
    v = mathsum();
c = new CssMathFunction(ac, n.image, v);
    label_173:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[269] = jj_gen;
        break label_173;
      }
      jj_consume_token(S);
    }
    label_174:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[270] = jj_gen;
        break label_174;
      }
      jj_consume_token(COMMA);
      label_175:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[271] = jj_gen;
          break label_175;
        }
        jj_consume_token(S);
      }
      v = mathsum();
c.addValue(v);
      label_176:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[272] = jj_gen;
          break label_176;
        }
        jj_consume_token(S);
      }
    }
    jj_consume_token(RPAREN);
c.validate();
    {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathfunctionround() throws ParseException {CssCheckableValue v;
    CssMathFunction c;
    Token n;
    n = jj_consume_token(FUNCTIONROUND);
c = new CssMathFunction(ac, n.image);
    label_177:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[273] = jj_gen;
        break label_177;
      }
      jj_consume_token(S);
    }
    if (jj_2_24(2)) {
      n = jj_consume_token(IDENT);
c.addValue(CssIdent.getIdent(convertIdent(n.image)));
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case IDENT:
      case LPAREN:
      case RELFONTLENGTH:
      case RELVIEWLENGTH:
      case ABSOLUTLENGTH:
      case FLEX:
      case ANGLE:
      case TIME:
      case FREQ:
      case PERCENTAGE:
      case NUMBER:
      case FUNCTIONCALC:
      case FUNCTIONMATHN:
      case FUNCTIONMATH1:
      case FUNCTIONMATH2:
      case FUNCTIONROUND:
      case FUNCTIONCLAMP:
      case FUNCTIONATTR:
      case FUNCTIONVAR:{
        v = mathsum();
c.addValue(v);
        break;
        }
      default:
        jj_la1[274] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_178:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[275] = jj_gen;
        break label_178;
      }
      jj_consume_token(S);
    }
    label_179:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[276] = jj_gen;
        break label_179;
      }
      jj_consume_token(COMMA);
      label_180:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[277] = jj_gen;
          break label_180;
        }
        jj_consume_token(S);
      }
      v = mathsum();
c.addValue(v);
      label_181:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[278] = jj_gen;
          break label_181;
        }
        jj_consume_token(S);
      }
    }
    jj_consume_token(RPAREN);
c.validate();
    {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathfunction1() throws ParseException {CssCheckableValue v;
    CssMathFunction c;
    Token n;
    n = jj_consume_token(FUNCTIONMATH1);
    label_182:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[279] = jj_gen;
        break label_182;
      }
      jj_consume_token(S);
    }
    v = mathsum();
c = new CssMathFunction(ac, n.image, v);
    label_183:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[280] = jj_gen;
        break label_183;
      }
      jj_consume_token(S);
    }
    jj_consume_token(RPAREN);
c.validate();
    {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathfunction2() throws ParseException {CssCheckableValue v;
    CssMathFunction c;
    Token n;
    n = jj_consume_token(FUNCTIONMATH2);
    label_184:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[281] = jj_gen;
        break label_184;
      }
      jj_consume_token(S);
    }
    v = mathsum();
c = new CssMathFunction(ac, n.image, v);
    label_185:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[282] = jj_gen;
        break label_185;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      label_186:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[283] = jj_gen;
          break label_186;
        }
        jj_consume_token(S);
      }
      v = mathsum();
c.addValue(v);
      label_187:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[284] = jj_gen;
          break label_187;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[285] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
c.validate();
    {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathclamp() throws ParseException {CssCheckableValue v1, v2, v3;
    CssMathFunction c;
    Token n;
    n = jj_consume_token(FUNCTIONCLAMP);
    label_188:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[286] = jj_gen;
        break label_188;
      }
      jj_consume_token(S);
    }
    v1 = mathsum();
    label_189:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[287] = jj_gen;
        break label_189;
      }
      jj_consume_token(S);
    }
    jj_consume_token(COMMA);
    label_190:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[288] = jj_gen;
        break label_190;
      }
      jj_consume_token(S);
    }
    v2 = mathsum();
    label_191:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[289] = jj_gen;
        break label_191;
      }
      jj_consume_token(S);
    }
    jj_consume_token(COMMA);
    label_192:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[290] = jj_gen;
        break label_192;
      }
      jj_consume_token(S);
    }
    v3 = mathsum();
    label_193:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[291] = jj_gen;
        break label_193;
      }
      jj_consume_token(S);
    }
    jj_consume_token(RPAREN);
c = new CssMathFunction(ac, n.image);
        c.addValue(v1);
        c.addValue(v2);
        c.addValue(v3);
        c.validate();
        {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathcalc() throws ParseException {CssCheckableValue v;
CssCalc c;
Token n;
    n = jj_consume_token(FUNCTIONCALC);
    label_194:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[292] = jj_gen;
        break label_194;
      }
      jj_consume_token(S);
    }
    v = mathsum();
    label_195:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[293] = jj_gen;
        break label_195;
      }
      jj_consume_token(S);
    }
    jj_consume_token(RPAREN);
String funcname = n.image.toLowerCase();
    if (funcname.charAt(0) == '-') {
        if (ac.getTreatVendorExtensionsAsWarnings()) {
            ac.getFrame().addWarning("vendor-extension",
                    funcname.substring(0, funcname.length() - 1));
        } else {
            addError(new ParseException(ac.getMsg()
                    .getString("warning.vendor-extension")),
                funcname);
        }
    }
    if (v.getRawType() != CssTypes.CSS_CALC) {
       c = new CssCalc(v);
    } else {
       c = (CssCalc) v;
    }
    c.validate();
    c.setImplicitFunction(false);
    {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathsum() throws ParseException {Token n,o;
  CssCheckableValue v1 = null;
  CssCheckableValue v2 = null;
  CssCalc c, nc;
  boolean concat = false;
  int nb_pre_sp;
    v1 = mathproduct();
c = new CssCalc(ac, v1);
                          nb_pre_sp = 0;
    label_196:
    while (true) {
      if (jj_2_25(2)) {
        ;
      } else {
        break label_196;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        o = jj_consume_token(PLUS);
        break;
        }
      case S:
      case MINUS:{
        label_197:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[294] = jj_gen;
            break label_197;
          }
          jj_consume_token(S);
nb_pre_sp++;
        }
        o = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[295] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (o.image.length() < 2 && nb_pre_sp == 0) {
                {if (true) throw new ParseException(ac.getMsg().getString("parser.calcwhitespace"));}
            }
      label_198:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[296] = jj_gen;
          break label_198;
        }
      }
      v2 = mathproduct();
nb_pre_sp = 0;
            if (concat) {
                nc = new CssCalc(ac, c);
                if (c.hasCssVariable()) {
                    nc.markCssVariable();
                }
                nc.addRightSide(o.image.trim(), v2);
                c = nc;
            } else {
                c.addRightSide(o.image.trim(), v2);
                concat = true;
            }
    }
{if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathproduct() throws ParseException {Token n,o;
  CssCheckableValue v1 = null;
  CssCheckableValue v2 = null;
  CssValue f;
  CssCalc c, nc;
  char operator = ' ';
  boolean concat = false;
    v1 = mathunit();
c = new CssCalc(ac, v1);
    label_199:
    while (true) {
      if (jj_2_26(2)) {
        ;
      } else {
        break label_199;
      }
      label_200:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[297] = jj_gen;
          break label_200;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ANY:{
        o = jj_consume_token(ANY);
        label_201:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[298] = jj_gen;
            break label_201;
          }
          jj_consume_token(S);
        }
        v2 = mathunit();
        break;
        }
      case DIV:{
        o = jj_consume_token(DIV);
        label_202:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[299] = jj_gen;
            break label_202;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:
        case IDENT:
        case LPAREN:
        case NUMBER:{
          v2 = calcnumbervalue();
          break;
          }
        case FUNCTIONVAR:{
          v2 = functionvar();
if (v2.getType() == CssTypes.CSS_VARIABLE) {
                         c.markCssVariable();
                     }
          break;
          }
        default:
          jj_la1[300] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[301] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (concat) {
             nc = new CssCalc(ac, c);
             if (c.hasCssVariable()) {
                 nc.markCssVariable();
             }
             nc.addRightSide(o.image, v2);
             c = nc;
         } else {
             c.addRightSide(o.image, v2);
             concat = true;
         }
    }
{if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue calcnumbervalue() throws ParseException {Token n,o;
  CssCheckableValue v = null;
  char operator = ' ';
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case IDENT:
    case NUMBER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        operator = unaryOperator();
        break;
        }
      default:
        jj_la1[302] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        n = jj_consume_token(NUMBER);
        break;
        }
      case IDENT:{
        n = jj_consume_token(IDENT);
        break;
        }
      default:
        jj_la1[303] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
v = new CssNumber(); v.set(addOperator(operator, n.image), ac);
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      label_203:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[304] = jj_gen;
          break label_203;
        }
        jj_consume_token(S);
      }
      v = calcnumbersum();
      label_204:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[305] = jj_gen;
          break label_204;
        }
        jj_consume_token(S);
      }
      jj_consume_token(RPAREN);
try { ((CssCalc) v).setParenthesis(); } catch (Exception ex) { ex.printStackTrace();}
      break;
      }
    default:
      jj_la1[306] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return v;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue calcnumbersum() throws ParseException {Token n,o;
  CssCheckableValue v1 = null;
  CssCheckableValue v2 = null;
  CssCalc c, nc;
  char operator = ' ';
  boolean concat = false;
  int nb_pre_sp;
    v1 = calcnumberproduct();
c = new CssCalc(ac, v1); nb_pre_sp = 0;
    label_205:
    while (true) {
      if (jj_2_27(2)) {
        ;
      } else {
        break label_205;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        o = jj_consume_token(PLUS);
        break;
        }
      case S:
      case MINUS:{
        label_206:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[307] = jj_gen;
            break label_206;
          }
          jj_consume_token(S);
nb_pre_sp++;
        }
        o = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[308] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (o.image.length() < 2 && nb_pre_sp == 0) {
                {if (true) throw new ParseException(ac.getMsg().getString("parser.calcwhitespace"));}
            }
      label_207:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[309] = jj_gen;
          break label_207;
        }
      }
      v2 = calcnumberproduct();
nb_pre_sp = 0;
            if (concat) {
                nc = new CssCalc(ac, c);
                nc.addRightSide(o.image.trim(), v2);
                c = nc;
            } else {
                c.addRightSide(o.image.trim(), v2);
                concat = true;
            }
    }
{if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue calcnumberproduct() throws ParseException {Token n,o;
  CssCheckableValue v1 = null;
  CssCheckableValue v2 = null;
  CssCalc c, nc;
  char operator = ' ';
  boolean concat = false;
    v1 = calcnumbervalue();
c = new CssCalc(ac, v1);
    label_208:
    while (true) {
      if (jj_2_28(2)) {
        ;
      } else {
        break label_208;
      }
      label_209:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[310] = jj_gen;
          break label_209;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DIV:{
        o = jj_consume_token(DIV);
        break;
        }
      case ANY:{
        o = jj_consume_token(ANY);
        break;
        }
      default:
        jj_la1[311] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_210:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[312] = jj_gen;
          break label_210;
        }
        jj_consume_token(S);
      }
      v2 = calcnumbervalue();
if (concat) {
                              nc = new CssCalc(ac, c);
                              nc.addRightSide(o.image, v2);
                              c = nc;
                          } else {
                              c.addRightSide(o.image, v2);
                              concat = true;
                          }
    }
{if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathunit() throws ParseException {Token n;
CssCheckableValue v = null;
char operator = ' ';
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case IDENT:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case FLEX:
    case ANGLE:
    case TIME:
    case FREQ:
    case PERCENTAGE:
    case NUMBER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        operator = unaryOperator();
        break;
        }
      default:
        jj_la1[313] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case NUMBER:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NUMBER:{
          n = jj_consume_token(NUMBER);
          break;
          }
        case IDENT:{
          n = jj_consume_token(IDENT);
          break;
          }
        default:
          jj_la1[314] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
v = new CssNumber(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
v = new CssPercentage(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case RELFONTLENGTH:{
        n = jj_consume_token(RELFONTLENGTH);
v = new CssLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case RELVIEWLENGTH:{
        n = jj_consume_token(RELVIEWLENGTH);
v = new CssLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case ABSOLUTLENGTH:{
        n = jj_consume_token(ABSOLUTLENGTH);
v = new CssLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case FLEX:{
        n = jj_consume_token(FLEX);
v = new CssFlexibleLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case ANGLE:{
        n = jj_consume_token(ANGLE);
v = new CssAngle(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case TIME:{
        n = jj_consume_token(TIME);
v = new CssTime(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case FREQ:{
        n = jj_consume_token(FREQ);
v= new CssFrequency(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      default:
        jj_la1[315] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      label_211:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[316] = jj_gen;
          break label_211;
        }
        jj_consume_token(S);
      }
      v = mathsum();
      label_212:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[317] = jj_gen;
          break label_212;
        }
        jj_consume_token(S);
      }
      jj_consume_token(RPAREN);
((CssCalc) v).setParenthesis();
      break;
      }
    case FUNCTIONCALC:{
      v = mathcalc();
      break;
      }
    case FUNCTIONMATHN:
    case FUNCTIONMATH1:
    case FUNCTIONMATH2:
    case FUNCTIONROUND:{
      v = mathfunction();
      break;
      }
    case FUNCTIONCLAMP:{
      v = mathclamp();
      break;
      }
    case FUNCTIONATTR:{
      v = attr();
      break;
      }
    case FUNCTIONVAR:{
      v = functionvar();
      break;
      }
    default:
      jj_la1[318] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return v;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue attr() throws ParseException {CssAttr v = null;
Token n = null;
CssExpression exp = null;
    jj_consume_token(FUNCTIONATTR);
    label_213:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[319] = jj_gen;
        break label_213;
      }
      jj_consume_token(S);
    }
    n = ident();
    label_214:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[320] = jj_gen;
        break label_214;
      }
      jj_consume_token(S);
    }
exp = new CssExpression();
            setValue(new CssIdent(), exp, ' ', n, IDENT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:
    case ONLY:
    case NOT:
    case IDENT:
    case 148:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        n = ident();
        break;
        }
      case 148:{
        n = jj_consume_token(148);
        break;
        }
      default:
        jj_la1[321] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
setValue(new CssIdent(), exp, ' ', n, IDENT);
      label_215:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[322] = jj_gen;
          break label_215;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[323] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
exp.setOperator(',');
      label_216:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[324] = jj_gen;
          break label_216;
        }
        jj_consume_token(S);
      }
      term(exp);
      break;
      }
    default:
      jj_la1[325] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
v = new CssAttr();
       v.setValue(exp, ac);
       {if ("" != null) return v;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue functionvar() throws ParseException {Token n;
 CssExpression exp = null;
 CssExpression e;
 CssVariable var;
    jj_consume_token(FUNCTIONVAR);
    label_217:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[326] = jj_gen;
        break label_217;
      }
      jj_consume_token(S);
    }
    n = jj_consume_token(CUSTOM_PROPERTY_NAME);
var = new CssVariable(ac, convertIdent(n.image));
    label_218:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[327] = jj_gen;
        break label_218;
      }
      jj_consume_token(COMMA);
      label_219:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[328] = jj_gen;
          break label_219;
        }
        jj_consume_token(S);
      }
      try {
        e = expr();
      } catch (ParseException pe) {
String s = skip_to_matching_paren();
                        // FIXME do something meaningful with that string
                        e = null;
      }
if (e != null) {
                             if (exp == null) {
                                 exp = e;
                             } else {
                                 exp.setOperator(CssOperator.COMMA);
                                 while (!e.end()) {
                                    exp.addValue(e.getValue());
                                    exp.setOperator(e.getOperator());
                                    e.next();
                                 }
                             }
                         }
    }
    label_220:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[329] = jj_gen;
        break label_220;
      }
      jj_consume_token(S);
    }
    jj_consume_token(RPAREN);
if (exp != null) {
        var.set(exp);
    }
    {if ("" != null) return var;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssValue function() throws ParseException {Token n,p = null,q = null;
 CssExpression exp = new CssExpression();
 CssColor color = new CssColor();
    n = jj_consume_token(FUNCTION);
    label_221:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[330] = jj_gen;
        break label_221;
      }
      jj_consume_token(S);
    }
    if (jj_2_29(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case STRING:
      case IDENT:
      case HASHIDENT:
      case HASH:
      case PROGID:
      case DIV:
      case LBRACKET:
      case RBRACKET:
      case URL:
      case RELFONTLENGTH:
      case RELVIEWLENGTH:
      case ABSOLUTLENGTH:
      case FLEX:
      case ANGLE:
      case SPL:
      case ST:
      case TIME:
      case FREQ:
      case RESOLUTION:
      case DIMEN_9:
      case DIMEN:
      case PERCENTAGE:
      case NUMBER:
      case IMPORTANT_NOT:
      case UNICODERANGE:
      case FUNCTIONCALC:
      case FUNCTIONMATHN:
      case FUNCTIONMATH1:
      case FUNCTIONMATH2:
      case FUNCTIONROUND:
      case FUNCTIONCLAMP:
      case FUNCTIONATTR:
      case FUNCTIONVAR:
      case FUNCTION:{
        exp = expr();
        break;
        }
      default:
        jj_la1[331] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
String funcname = n.image.toLowerCase();
        if (funcname.equals("rgb(")) {
            color.setRGBColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("rgba(")) {
            color.setRGBAColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("hsl(")) {
            color.setHSLColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("hsla(")) {
            color.setHSLColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("hwb(")) {
            color.setHWBColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("lab(")) {
            color.setLABColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("lch(")) {
            color.setLCHColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("device-cmyk(")) {
            color.setDeviceCMYKColor(ac, exp);
            {if ("" != null) return color;}
        } else if (funcname.equals("light-dark(")) {
            color.setLightDark(ac, exp);
            {if ("" != null) return color;}
/*
        } else if (funcname.equals("color-mix(")) {
	    color.setColorMix(ac, exp);
	    return color;
*/
        } else if (funcname.equals("image(")) {
            CssImage img = new CssImage();
            img.setImageList(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("linear-gradient(")) {
            CssImage img = new CssImage();
            img.setLinearGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("repeating-linear-gradient(")) {
            CssImage img = new CssImage();
            img.setRepeatingLinearGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("radial-gradient(")) {
            CssImage img = new CssImage();
            img.setRadialGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("repeating-radial-gradient(")) {
            CssImage img = new CssImage();
            img.setRepeatingRadialGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("conic-gradient(")) {
            CssImage img = new CssImage();
            img.setConicGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("repeating-conic-gradient(")) {
            CssImage img = new CssImage();
            img.setRepeatingConicGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("atsc-rgba(")) {
            if (getAtRule().toString().equals("@media atsc-tv")) {
                color.setATSCRGBAColor(ac, exp);
                {if ("" != null) return color;}
            } else {
                addError(new InvalidParamException("onlyATSC", "", ac),
                                                 getAtRule().toString());
                {if ("" != null) return null;}
            }
        } else {
            CssFunction f = new CssFunction();
            f.set(n.image.substring(0, n.image.length() - 1), exp);
            if (funcname.charAt(0) == '-') {
                exp.markVendorExtension();
            }
            {if ("" != null) return f;}
        }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:
      case OR:
      case ONLY:
      case NOT:
      case IDENT:{
        p = ident();
        jj_consume_token(EQ);
        q = jj_consume_token(NUMBER);
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[332] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
// this one is for vendor extension like alpha(opacity=50);
        exp = new CssExpression();
        setValue(new CssIdent(), exp, ' ', p, IDENT);
        exp.setOperator(CssOperator.EQUAL);
        setValue(new CssNumber(), exp, ' ', q, NUMBER);
        exp.markVendorExtension();

        CssFunction f = new CssFunction();
        f.set(n.image.substring(0, n.image.length() - 1), exp);
        {if ("" != null) return f;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void hashident(CssExpression exp) throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HASHIDENT:{
      n = jj_consume_token(HASHIDENT);
      break;
      }
    case HASH:{
      n = jj_consume_token(HASH);
      break;
      }
    default:
      jj_la1[333] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
n.image = Util.strip(n.image);
     setValue(new CssHashIdent(), exp, ' ', n, HASH);
  }

  String skipStatement() throws ParseException {StringBuilder s = new StringBuilder();
    Token tok = getToken(0);
    boolean first = true;

    if (tok.image != null) {
        s.append(tok.image);
    }
    /* FIXME here, two option, we skip during an error, or outside
       an error, currently both can fail with a TokenMgrError, should
       we catch all, or only when filling message for errors? 
       
       -> taking the "always skip" approach.
    */
    while (true) {
        try {
            tok = getToken(1);
            if (tok.kind == EOF) {
                if (first) {
                    return null;
                } else {
                    break;
                }
            }
            if (tok.kind == LBRACE) {
                s.append(tok.image);
                getNextToken();
                s.append(skip_to_matching_brace());
                getNextToken();
                tok = getToken(1);
                break;
            } else if ((tok.kind == RBRACE) || (tok.kind == SEMICOLON)) {
                s.append(tok.image);
                // we might need a mode here, skip to brace or to semicolon (or both)
                getNextToken();
                tok = getToken(1);
                break;
            } else if ((tok.kind == SCO) && (ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0)) {
                // we found a comment start, meaning it is not terminated, we
                // must "eat" until EOF
                do {
                        tok = getNextToken();
                } while (tok.kind != EOF);
                break;
            } else {
                s.append(tok.image);
            }
            getNextToken();
        } catch (TokenMgrError tokenerror) {
            // read one char at a time, and loop
            try {
                s.append(jj_input_stream.readChar());
                continue;
            } catch (java.io.IOException ioex) {
                return s.toString().trim();
            }
        }
        first = false;
    }
    // skip white space
    while (tok.kind == S) {
        getNextToken();
        tok = getToken(1);
    }
    String statement = s.toString().trim();
    return statement;
  }

  String skip_to_matching_brace() throws ParseException {StringBuilder s = new StringBuilder();
    Token tok;
    int nesting = 1;
    /* FIXME
       same as above */
    while (true) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            break;
        }
        if (tok.kind == LBRACE) {
            nesting++;
        } else if (tok.kind == RBRACE) {
            nesting--;
            if (nesting == 0) {
                s.append(tok.image);
                break;
            }
        }
        s.append(tok.image);
        getNextToken();
    }
    return s.toString();
  }

  String skip_to_matching_paren() throws ParseException {StringBuilder s = new StringBuilder();
    Token tok;
    int nesting = 1;
    /* FIXME
       same as above */
    while (nesting > 0) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            break;
        }
        switch(tok.kind) {
            case LPAREN:
            case FUNCTION:
            case FUNCTIONLANG:
            case FUNCTIONDIR:
            case FUNCTIONIS:
            case FUNCTIONWHERE:
            case FUNCTIONHAS:
            case FUNCTIONHOST:
            case FUNCTIONHOSTCONTEXT:
            case FUNCTIONSLOTTED:
            case FUNCTIONNTHCHILD:
            case FUNCTIONNTHLASTCHILD:
            case FUNCTIONNTHCOL:
            case FUNCTIONNTHLASTCOL:
            case FUNCTIONNTHOFTYPE:
            case FUNCTIONNTHLASTOFTYPE:
            case FUNCTIONNOT:
            case FUNCTIONCALC:
            case FUNCTIONMATHN:
            case FUNCTIONMATH1:
            case FUNCTIONMATH2:
            case FUNCTIONCLAMP:
            case FUNCTIONROUND:
            case FUNCTIONATTR:
            case FUNCTIONVAR:
                s.append(tok.image);
                nesting++;
                getNextToken();
                break;
            case RPAREN:
                nesting--;
                if (nesting == 0) {
                    break;
                }
            default:
                s.append(tok.image);
                getNextToken();
        }
    }
    return s.toString();
  }

  void rejectToken(Token t) throws ParseException {Token fakeToken = new Token();
    t.next = token;
    fakeToken.next = t;
    token = fakeToken;
  }

  void skipAfterExpression(Exception e) throws ParseException {StringBuilder s = new StringBuilder();
    s.append(getToken(0).image);
    while (true) {
        try {
            Token t = getToken(1);
            if (t.kind == LBRACE) {
                s.append(t.image);
                getNextToken();
                s.append(skip_to_matching_brace());
                getNextToken();
                t = getToken(1);
                continue;
            }
            if ((t.kind == SEMICOLON) || (t.kind == RBRACE)
                                      || (t.kind == EOF)) {
                break;
            }
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        } catch (TokenMgrError tmerr) {
            try {
                s.append(jj_input_stream.readChar());
                continue;
            } catch (java.io.IOException ioex) {
                ioex.printStackTrace();
                break;
            }
        }
    }
    String statement = s.toString().trim();
    addError(e, s.toString());
  }

  public String convertStringIndex(String s, int start, int len, boolean escapeFirst) throws ParseException {try {
                return StringUtils.convertStringIndex(s, start, len, escapeFirst, ac);
        } catch (InvalidParamException nex) {
                throw new ParseException("invalid string");
        }
  }

  String convertIdent(String s) throws ParseException, ParseException {try {
                return StringUtils.convertIdent(s, ac);
        } catch (InvalidParamException nex) {
                throw new ParseException("invalid string");
        }
  }

  String convertClassIdent(String s) throws ParseException {try {
                return StringUtils.convertClassIdent(s, ac);
        } catch (InvalidParamException nex) {
                throw new ParseException("invalid string");
        }
  }

  String convertString(String s) throws ParseException {try {
                return StringUtils.convertString(s, ac);
        } catch (InvalidParamException nex) {
                throw new ParseException("invalid string");
        }
  }

  String hexEscapeFirst(String s) throws ParseException {StringBuilder sb = new StringBuilder();
    sb.append('\\').append(Integer.toString(s.charAt(0), 16));
    char c = s.charAt(1);
    if (((c >= '0') && (c <= '9')) ||
        ((c >= 'A') && (c <= 'F')) ||
        ((c >= 'a') && (c <= 'f'))) {
        sb.append(' ');
    }
    sb.append(s.substring(1));
    return sb.toString();
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_3R_452()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_300()
 {
    if (jj_3R_232()) return true;
    return false;
  }

  private boolean jj_3R_451()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_299()
 {
    if (jj_3R_370()) return true;
    return false;
  }

  private boolean jj_3R_450()
 {
    if (jj_scan_token(DIMEN)) return true;
    return false;
  }

  private boolean jj_3R_298()
 {
    if (jj_3R_369()) return true;
    return false;
  }

  private boolean jj_3R_297()
 {
    if (jj_3R_368()) return true;
    return false;
  }

  private boolean jj_3R_449()
 {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_448()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_263()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_297()) {
    jj_scanpos = xsp;
    if (jj_3R_298()) {
    jj_scanpos = xsp;
    if (jj_3R_299()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_447()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_446()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_441()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_446()) {
    jj_scanpos = xsp;
    if (jj_3R_447()) {
    jj_scanpos = xsp;
    if (jj_3R_448()) {
    jj_scanpos = xsp;
    if (jj_3R_449()) {
    jj_scanpos = xsp;
    if (jj_3R_450()) {
    jj_scanpos = xsp;
    if (jj_3R_451()) {
    jj_scanpos = xsp;
    if (jj_3R_452()) return true;
    }
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_431()
 {
    Token xsp;
    if (jj_3R_441()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_441()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_376()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) return true;
    }
    return false;
  }

  private boolean jj_3R_405()
 {
    if (jj_3R_238()) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_443()
 {
    if (jj_3R_255()) return true;
    return false;
  }

  private boolean jj_3R_437()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_443()) jj_scanpos = xsp;
    if (jj_3R_435()) return true;
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_3R_279()) return true;
    return false;
  }

  private boolean jj_3R_394()
 {
    if (jj_3R_408()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_248()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_375()
 {
    if (jj_scan_token(FUNCTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3R_405()) return true;
    }
    return false;
  }

  private boolean jj_3R_428()
 {
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3R_396()
 {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  private boolean jj_3R_458()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_459()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_360()
 {
    if (jj_scan_token(FUNCTIONVAR)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CUSTOM_PROPERTY_NAME)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_459()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_460()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_457()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_460()) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) return true;
    }
    return false;
  }

  private boolean jj_3R_384()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) return true;
    }
    return false;
  }

  private boolean jj_3R_374()
 {
    if (jj_scan_token(FUNCTIONATTR)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_238()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_457()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_458()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_362()
 {
    if (jj_3R_393()) return true;
    return false;
  }

  private boolean jj_3R_359()
 {
    if (jj_3R_360()) return true;
    return false;
  }

  private boolean jj_3R_358()
 {
    if (jj_3R_374()) return true;
    return false;
  }

  private boolean jj_3R_357()
 {
    if (jj_3R_373()) return true;
    return false;
  }

  private boolean jj_3R_356()
 {
    if (jj_3R_372()) return true;
    return false;
  }

  private boolean jj_3R_430()
 {
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3R_355()
 {
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3R_354()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_400()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_392()
 {
    if (jj_scan_token(FREQ)) return true;
    return false;
  }

  private boolean jj_3R_391()
 {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_390()
 {
    if (jj_scan_token(ANGLE)) return true;
    return false;
  }

  private boolean jj_3R_389()
 {
    if (jj_scan_token(FLEX)) return true;
    return false;
  }

  private boolean jj_3R_388()
 {
    if (jj_scan_token(ABSOLUTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_387()
 {
    if (jj_scan_token(RELVIEWLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_383()
 {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_386()
 {
    if (jj_scan_token(RELFONTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_385()
 {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_353()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_383()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_384()) {
    jj_scanpos = xsp;
    if (jj_3R_385()) {
    jj_scanpos = xsp;
    if (jj_3R_386()) {
    jj_scanpos = xsp;
    if (jj_3R_387()) {
    jj_scanpos = xsp;
    if (jj_3R_388()) {
    jj_scanpos = xsp;
    if (jj_3R_389()) {
    jj_scanpos = xsp;
    if (jj_3R_390()) {
    jj_scanpos = xsp;
    if (jj_3R_391()) {
    jj_scanpos = xsp;
    if (jj_3R_392()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_273()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_353()) {
    jj_scanpos = xsp;
    if (jj_3R_354()) {
    jj_scanpos = xsp;
    if (jj_3R_355()) {
    jj_scanpos = xsp;
    if (jj_3R_356()) {
    jj_scanpos = xsp;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) {
    jj_scanpos = xsp;
    if (jj_3R_359()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_368()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_395()) {
    jj_scanpos = xsp;
    if (jj_3R_396()) return true;
    }
    return false;
  }

  private boolean jj_3R_395()
 {
    if (jj_scan_token(HASHIDENT)) return true;
    return false;
  }

  private boolean jj_3R_440()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_294()
 {
    if (jj_scan_token(FUNCTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_431()) return true;
    return false;
  }

  private boolean jj_3R_363()
 {
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_276()
 {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_429()
 {
    if (jj_3R_439()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_246()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_276()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_282()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_363()) return true;
    }
    return false;
  }

  private boolean jj_3_28()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_247()) return true;
    return false;
  }

  private boolean jj_3R_293()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_429()) {
    jj_scanpos = xsp;
    if (jj_3R_430()) return true;
    }
    return false;
  }

  private boolean jj_3R_438()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_427()
 {
    if (jj_3R_439()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_440()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_3R_254()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_426()
 {
    if (jj_3R_437()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_438()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_292()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) return true;
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_427()) {
    jj_scanpos = xsp;
    if (jj_3R_428()) return true;
    }
    return false;
  }

  private boolean jj_3_27()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_3R_246()) return true;
    }
    if (jj_scan_token(21)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_291()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_230()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_253()
 {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_436()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_224()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) return true;
    }
    return false;
  }

  private boolean jj_3R_252()
 {
    if (jj_scan_token(NOT)) return true;
    Token xsp;
    if (jj_scan_token(21)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_425()
 {
    if (jj_3R_435()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_436()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_290()
 {
    if (jj_scan_token(FUNCTIONHAS)) return true;
    if (jj_3R_426()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_6()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_226()) jj_scanpos = xsp;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_434()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_361()
 {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_289()
 {
    if (jj_scan_token(FUNCTIONWHERE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_425()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_278()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_277()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_361()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) return true;
    }
    return false;
  }

  private boolean jj_3R_247()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) return true;
    }
    return false;
  }

  private boolean jj_3R_424()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_3R_434()) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_288()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_425()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_3R_254()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_287()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_275()
 {
    if (jj_3R_360()) return true;
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_442()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_261()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) {
    jj_scanpos = xsp;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) return true;
    }
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_274()
 {
    if (jj_3R_247()) return true;
    return false;
  }

  private boolean jj_3R_433()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_442()) jj_scanpos = xsp;
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_408()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_423()) {
    jj_scanpos = xsp;
    if (jj_3R_424()) return true;
    }
    return false;
  }

  private boolean jj_3R_423()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_433()) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_453()
 {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_260()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_245()
 {
    if (jj_scan_token(DIV)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) return true;
    }
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_244()
 {
    if (jj_scan_token(ANY)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_273()) return true;
    return false;
  }

  private boolean jj_3R_445()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_453()) jj_scanpos = xsp;
    if (jj_scan_token(DIMEN)) return true;
    xsp = jj_scanpos;
    if (jj_3_7()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_26()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) return true;
    }
    return false;
  }

  private boolean jj_3R_272()
 {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_228()) jj_scanpos = xsp;
    if (jj_scan_token(AN)) return true;
    xsp = jj_scanpos;
    if (jj_3_6()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_260()) {
    jj_scanpos = xsp;
    if (jj_3R_261()) return true;
    }
    return false;
  }

  private boolean jj_3_5()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_225()) jj_scanpos = xsp;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_243()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_272()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_418()
 {
    if (jj_3R_273()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_26()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_8()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_227()) jj_scanpos = xsp;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_407()
 {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_444()
 {
    if (jj_3R_238()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_439()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_444()) {
    jj_scanpos = xsp;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3R_445()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_393()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(IDENT)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_407()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_280()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_362()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_25()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_3R_243()) return true;
    }
    if (jj_scan_token(21)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_284()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_258()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_283()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_254()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) return true;
    }
    return false;
  }

  private boolean jj_3R_259()
 {
    if (jj_scan_token(FUNCTIONSLOTTED)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_230()) return true;
    return false;
  }

  private boolean jj_3R_400()
 {
    if (jj_3R_418()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_25()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_367()
 {
    if (jj_scan_token(TWOPIPES)) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    if (jj_3R_280()) return true;
    return false;
  }

  private boolean jj_3R_366()
 {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_286()
 {
    Token xsp;
    if (jj_scan_token(21)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_365()
 {
    if (jj_scan_token(GREATER)) return true;
    return false;
  }

  private boolean jj_3R_364()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) return true;
    }
    return false;
  }

  private boolean jj_3R_249()
 {
    if (jj_scan_token(NOT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_280()) return true;
    return false;
  }

  private boolean jj_3R_285()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_364()) {
    jj_scanpos = xsp;
    if (jj_3R_365()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) {
    jj_scanpos = xsp;
    if (jj_3R_367()) return true;
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_255()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) return true;
    }
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_scan_token(PSEUDOELEMENT_SYM)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_258()) {
    jj_scanpos = xsp;
    if (jj_3R_259()) return true;
    }
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_267()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_239()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_267()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_371()
 {
    if (jj_scan_token(FUNCTIONCALC)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_400()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_406()
 {
    if (jj_scan_token(NUMBER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DIV)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_373()
 {
    if (jj_scan_token(FUNCTIONCLAMP)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_400()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(COMMA)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_454()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_404()
 {
    if (jj_3R_422()) return true;
    return false;
  }

  private boolean jj_3R_420()
 {
    if (jj_scan_token(FUNCTIONMATH2)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_400()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_454()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_419()
 {
    if (jj_scan_token(FUNCTIONMATH1)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_400()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_456()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_403()
 {
    if (jj_3R_421()) return true;
    return false;
  }

  private boolean jj_3R_432()
 {
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_266()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_237()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) return true;
    }
    return false;
  }

  private boolean jj_3R_455()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_422()
 {
    if (jj_scan_token(FUNCTIONROUND)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3R_432()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_456()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_402()
 {
    if (jj_3R_420()) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    Token xsp;
    if (jj_scan_token(21)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_237()) jj_scanpos = xsp;
    if (jj_scan_token(153)) return true;
    return false;
  }

  private boolean jj_3R_417()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_416()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_421()
 {
    if (jj_scan_token(FUNCTIONMATHN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_400()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_455()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_415()
 {
    if (jj_scan_token(SUBSTRINGMATCH)) return true;
    return false;
  }

  private boolean jj_3R_414()
 {
    if (jj_scan_token(SUFFIXMATCH)) return true;
    return false;
  }

  private boolean jj_3R_413()
 {
    if (jj_scan_token(PREFIXMATCH)) return true;
    return false;
  }

  private boolean jj_3R_412()
 {
    if (jj_scan_token(DASHMATCH)) return true;
    return false;
  }

  private boolean jj_3R_410()
 {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_411()
 {
    if (jj_scan_token(INCLUDES)) return true;
    return false;
  }

  private boolean jj_3R_399()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_410()) {
    jj_scanpos = xsp;
    if (jj_3R_411()) {
    jj_scanpos = xsp;
    if (jj_3R_412()) {
    jj_scanpos = xsp;
    if (jj_3R_413()) {
    jj_scanpos = xsp;
    if (jj_3R_414()) {
    jj_scanpos = xsp;
    if (jj_3R_415()) return true;
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_416()) {
    jj_scanpos = xsp;
    if (jj_3R_417()) return true;
    }
    return false;
  }

  private boolean jj_3R_401()
 {
    if (jj_3R_419()) return true;
    return false;
  }

  private boolean jj_3R_372()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_401()) {
    jj_scanpos = xsp;
    if (jj_3R_402()) {
    jj_scanpos = xsp;
    if (jj_3R_403()) {
    jj_scanpos = xsp;
    if (jj_3R_404()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_370()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_17()) jj_scanpos = xsp;
    if (jj_3R_238()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_399()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_352()
 {
    if (jj_scan_token(UNICODERANGE)) return true;
    return false;
  }

  private boolean jj_3R_351()
 {
    if (jj_scan_token(URL)) return true;
    return false;
  }

  private boolean jj_3R_350()
 {
    if (jj_3R_376()) return true;
    return false;
  }

  private boolean jj_3R_264()
 {
    if (jj_3R_232()) return true;
    return false;
  }

  private boolean jj_3R_296()
 {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  private boolean jj_3R_295()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_348()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_349()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_382()
 {
    if (jj_3R_373()) return true;
    return false;
  }

  private boolean jj_3R_271()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_348()) {
    jj_scanpos = xsp;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) return true;
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_381()
 {
    if (jj_3R_372()) return true;
    return false;
  }

  private boolean jj_3R_380()
 {
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3R_379()
 {
    if (jj_3R_375()) return true;
    return false;
  }

  private boolean jj_3R_265()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) return true;
    }
    return false;
  }

  private boolean jj_3R_347()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_379()) {
    jj_scanpos = xsp;
    if (jj_3R_380()) {
    jj_scanpos = xsp;
    if (jj_3R_381()) {
    jj_scanpos = xsp;
    if (jj_3R_382()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_346()
 {
    if (jj_scan_token(DIMEN_9)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_236()) jj_scanpos = xsp;
    if (jj_scan_token(153)) return true;
    return false;
  }

  private boolean jj_3R_262()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) return true;
    }
    return false;
  }

  private boolean jj_3R_345()
 {
    if (jj_scan_token(IMPORTANT_NOT)) return true;
    return false;
  }

  private boolean jj_3R_344()
 {
    if (jj_scan_token(DIMEN)) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_3R_231()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_264()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(NUMBER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DIV)) return true;
    return false;
  }

  private boolean jj_3R_343()
 {
    if (jj_scan_token(SPL)) return true;
    return false;
  }

  private boolean jj_3R_342()
 {
    if (jj_scan_token(ST)) return true;
    return false;
  }

  private boolean jj_3R_341()
 {
    if (jj_scan_token(RESOLUTION)) return true;
    return false;
  }

  private boolean jj_3R_340()
 {
    if (jj_scan_token(FREQ)) return true;
    return false;
  }

  private boolean jj_3R_339()
 {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_338()
 {
    if (jj_scan_token(ANGLE)) return true;
    return false;
  }

  private boolean jj_3R_337()
 {
    if (jj_scan_token(FLEX)) return true;
    return false;
  }

  private boolean jj_3R_336()
 {
    if (jj_scan_token(ABSOLUTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_335()
 {
    if (jj_scan_token(RELVIEWLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_334()
 {
    if (jj_scan_token(RELFONTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_333()
 {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_377()
 {
    if (jj_3R_406()) return true;
    return false;
  }

  private boolean jj_3R_378()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_409()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_332()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_377()) {
    jj_scanpos = xsp;
    if (jj_3R_378()) return true;
    }
    return false;
  }

  private boolean jj_3R_331()
 {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_232()) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_331()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3R_335()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) {
    jj_scanpos = xsp;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_3R_339()) {
    jj_scanpos = xsp;
    if (jj_3R_340()) {
    jj_scanpos = xsp;
    if (jj_3R_341()) {
    jj_scanpos = xsp;
    if (jj_3R_342()) {
    jj_scanpos = xsp;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) {
    jj_scanpos = xsp;
    if (jj_3R_345()) {
    jj_scanpos = xsp;
    if (jj_3R_346()) {
    jj_scanpos = xsp;
    if (jj_3R_347()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_242()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_270()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) return true;
    }
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_330()
 {
    if (jj_scan_token(UNICODERANGE)) return true;
    return false;
  }

  private boolean jj_3R_329()
 {
    if (jj_scan_token(URL)) return true;
    return false;
  }

  private boolean jj_3R_328()
 {
    if (jj_3R_376()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_232()) return true;
    return false;
  }

  private boolean jj_3R_234()
 {
    if (jj_3R_263()) return true;
    return false;
  }

  private boolean jj_3R_281()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_327()
 {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_326()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    return false;
  }

  private boolean jj_3R_325()
 {
    if (jj_scan_token(DIV)) return true;
    return false;
  }

  private boolean jj_3R_324()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_323()
 {
    if (jj_3R_375()) return true;
    return false;
  }

  private boolean jj_3R_322()
 {
    if (jj_3R_360()) return true;
    return false;
  }

  private boolean jj_3R_321()
 {
    if (jj_3R_374()) return true;
    return false;
  }

  private boolean jj_3R_320()
 {
    if (jj_3R_373()) return true;
    return false;
  }

  private boolean jj_3R_319()
 {
    if (jj_3R_372()) return true;
    return false;
  }

  private boolean jj_3R_318()
 {
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3R_269()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_318()) {
    jj_scanpos = xsp;
    if (jj_3R_319()) {
    jj_scanpos = xsp;
    if (jj_3R_320()) {
    jj_scanpos = xsp;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) {
    jj_scanpos = xsp;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) {
    jj_scanpos = xsp;
    if (jj_3R_325()) {
    jj_scanpos = xsp;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) {
    jj_scanpos = xsp;
    if (jj_3R_328()) {
    jj_scanpos = xsp;
    if (jj_3R_329()) {
    jj_scanpos = xsp;
    if (jj_3R_330()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_231()) return true;
    return false;
  }

  private boolean jj_3R_317()
 {
    if (jj_scan_token(DIMEN_9)) return true;
    return false;
  }

  private boolean jj_3R_398()
 {
    if (jj_3R_409()) return true;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_3R_262()) return true;
    return false;
  }

  private boolean jj_3R_316()
 {
    if (jj_scan_token(IMPORTANT_NOT)) return true;
    return false;
  }

  private boolean jj_3R_315()
 {
    if (jj_scan_token(PROGID)) return true;
    return false;
  }

  private boolean jj_3R_369()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_397()) {
    jj_scanpos = xsp;
    if (jj_3R_398()) return true;
    }
    return false;
  }

  private boolean jj_3R_397()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_231()) return true;
    return false;
  }

  private boolean jj_3R_257()
 {
    Token xsp;
    if (jj_3_14()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_14()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_256()
 {
    if (jj_3R_262()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_11()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_15()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_233()) jj_scanpos = xsp;
    if (jj_3R_234()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_234()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_235()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_314()
 {
    if (jj_scan_token(DIMEN)) return true;
    return false;
  }

  private boolean jj_3R_313()
 {
    if (jj_scan_token(SPL)) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_312()
 {
    if (jj_scan_token(ST)) return true;
    return false;
  }

  private boolean jj_3R_311()
 {
    if (jj_scan_token(RESOLUTION)) return true;
    return false;
  }

  private boolean jj_3R_310()
 {
    if (jj_scan_token(FREQ)) return true;
    return false;
  }

  private boolean jj_3R_309()
 {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_308()
 {
    if (jj_scan_token(ANGLE)) return true;
    return false;
  }

  private boolean jj_3R_307()
 {
    if (jj_scan_token(FLEX)) return true;
    return false;
  }

  private boolean jj_3R_306()
 {
    if (jj_scan_token(ABSOLUTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_305()
 {
    if (jj_scan_token(RELVIEWLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_304()
 {
    if (jj_scan_token(RELFONTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_303()
 {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_302()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_239()) return true;
    if (jj_3R_242()) return true;
    return false;
  }

  private boolean jj_3R_301()
 {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_238()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_268()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_301()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) {
    jj_scanpos = xsp;
    if (jj_3R_304()) {
    jj_scanpos = xsp;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) {
    jj_scanpos = xsp;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) {
    jj_scanpos = xsp;
    if (jj_3R_309()) {
    jj_scanpos = xsp;
    if (jj_3R_310()) {
    jj_scanpos = xsp;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) {
    jj_scanpos = xsp;
    if (jj_3R_313()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) {
    jj_scanpos = xsp;
    if (jj_3R_315()) {
    jj_scanpos = xsp;
    if (jj_3R_316()) {
    jj_scanpos = xsp;
    if (jj_3R_317()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_240()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_22()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_3R_242()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_21()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_3R_238()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) return true;
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_241()) return true;
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_3R_255()) return true;
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_3R_241()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) return true;
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_238()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_281()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_223()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_229()) jj_scanpos = xsp;
    if (jj_3R_230()) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_3R_239()) return true;
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_435()
 {
    if (jj_3R_230()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_10()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_279()
 {
    if (jj_3R_240()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_19()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  /** Generated Token Manager. */
  public CssParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[334];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x1a00000,0x1a00000,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x1800000,0x1800000,0x200000,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x0,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x200000,0x50000000,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x200000,0x200000,0x0,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x0,0x0,0x200000,0x30000000,0x30000000,0x30000000,0x200000,0x200000,0x200000,0x200000,0x30000000,0x0,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x0,0x50000000,0x200000,0x200000,0x50200000,0x30000000,0x200000,0x200000,0x30000000,0x30000000,0x30000000,0x200000,0x200000,0x30000000,0x30000000,0x200000,0x0,0x30000000,0x50000000,0x50000000,0x50000000,0x200000,0x0,0x200000,0x50000000,0x0,0x200000,0x0,0x200000,0x200000,0x50000000,0x0,0x200000,0x50000000,0x200000,0x50200000,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x50200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x200000,0x6000000,0x200000,0x0,0x200000,0x200000,0x6000000,0x200000,0x200000,0x0,0x0,0x0,0x200000,0x0,0x200000,0x200000,0x200000,0x200000,0x200000,0x0,0x200000,0x200000,0x0,0x200000,0x200000,0x200000,0x200000,0x0,0x30000000,0x0,0x200000,0x200000,0x30000000,0x200000,0x0,0x0,0x0,0x200000,0x0,0x0,0x200000,0x30000000,0x0,0x200000,0x30000000,0x200000,0x30000000,0x200000,0x200000,0xc0000000,0x200000,0xc0000000,0x200000,0x200000,0xc0000000,0x200000,0xc0000000,0x30000000,0x200000,0x30000000,0x0,0x0,0x0,0x30000000,0x30000000,0x0,0x0,0x0,0x200000,0x0,0x200000,0x30000000,0x0,0x200000,0x200000,0x0,0x200000,0x200000,0x200000,0x30000000,0x200000,0x0,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x0,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x30200000,0x200000,0x200000,0x200000,0x200000,0x30000000,0x0,0x30000000,0x0,0x200000,0x200000,0x30000000,0x200000,0x30200000,0x200000,0x200000,0x0,0x200000,0x30000000,0x0,0x0,0x200000,0x200000,0x30000000,0x200000,0x200000,0x0,0x200000,0x0,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x200000,0x30000000,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x278,0x0,0x0,0x0,0xe9a00e78,0x0,0x0,0x0,0x0,0x0,0x278,0x10000080,0x0,0x0,0x0,0x10000080,0x0,0x4000260,0x0,0x0,0x4000260,0x0,0xe9a00e78,0xe9a00e78,0x0,0x0,0x0,0x1,0x0,0x60,0x0,0x60,0x0,0x0,0x8,0x260,0x0,0x0,0x8,0x0,0x10,0x18,0x18,0x4000040,0x0,0x8,0x0,0x4000040,0x0,0x0,0x4000000,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0xe9a00e78,0xe9a00e78,0x0,0x0,0x0,0x8,0x0,0x10,0x18,0x18,0x4000040,0x0,0xff4267b,0x0,0x4000000,0x0,0x278,0x0,0x0,0x0,0x0,0x8000278,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x8000278,0x0,0x1,0x0,0x8000000,0x8000000,0x8000278,0x0,0x0,0x0,0x278,0x0,0x0,0x0,0x0,0x278,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x6,0x0,0x0,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x278,0x0,0xef40003,0xef40003,0xef4227b,0x0,0x1000400,0x0,0xff4267b,0x1,0x0,0x1,0x0,0x0,0xff4267b,0x80000,0x0,0xff4267b,0x0,0x6,0x0,0x0,0xe9200c00,0xe9200c00,0xe9200c00,0xe9200c00,0xe9a00e78,0xe9200c00,0x6,0x800278,0xe9200c00,0x0,0x8000000,0x800278,0xe1000000,0xe0000000,0x800278,0x800278,0x800278,0x0,0x800278,0x800278,0x0,0x78000,0x0,0x2f8,0x0,0x0,0x78000,0x0,0x0,0x278,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x278,0x278,0x0,0x0,0x0,0x278,0x0,0x0,0x278,0xc00,0x0,0x0,0x8000000,0x0,0xf0701ef8,0x0,0x0,0x2f8,0x0,0x2f8,0x0,0x0,0x40000,0x0,0x40000,0x0,0x0,0x40000,0x0,0x40000,0xf0000ef8,0x0,0x0,0xe0001000,0x600000,0x10700ef8,0xf0701ef8,0x0,0x0,0x0,0xe0000000,0x0,0x10000ef8,0x0,0xf0000ef8,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0xe4000200,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000200,0x900000,0x0,0x200,0x0,0x0,0x4000200,0x0,0x0,0x0,0x0,0x900000,0x0,0x0,0x200,0xe0000200,0x0,0x0,0xe4000200,0x0,0x0,0x278,0x0,0x278,0x0,0x1,0x0,0x1,0x0,0x0,0x0,0xf0701ef8,0x278,0xc00,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x14272,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x14272,0x14272,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x14272,0x14272,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffe0000,0xfffe0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4272,0x4272,0x4272,0x4272,0x4272,0x272,0x0,0x0,0x272,0x4000,0x0,0x4000,0x272,0x272,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa80,0x0,0x0,0x0,0xa80,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x2f7f,0x1000,0x0,0xe00,0x0,0xe00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f7f,0x0,0x0,0x2f7f,0x0,0x0,0x2f7f,0x0,0x800,0x0,0x2f7f,0x0,0x0,0x0,0x2f7f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x800,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0xc33,0x0,0x0,0xc33,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f7f,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x2,0x4,0x0,0x0,0x0,0x3ef8,0x3ef8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ef8,0x3ef8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ef8,0x3ef8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x3000000,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xdf000000,0xdf000000,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x30000,0x30000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fc0000,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3fc0000,0x3fc0000,0x3fc0000,0x0,0x0,0x0,0x3fc0000,0x0,0x0,0x0,0x0,0x0,0x3fc0000,0x0,0x0,0x3fc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x2000000,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x33,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0x0,0x0,0x0,0x0,0x807f,0x807f,0x0,0x0,0x0,0x0,0x0,0xff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5000000,0x0,0x5000000,0x0,0x0,0x5000000,0x0,0x5000000,0x9f80,0x0,0x0,0x0,0x0,0xff80,0xff80,0x0,0x0,0x9f80,0x9f80,0x0,0x0,0x0,0x9f80,0xf00,0x0,0x0,0x0,0x0,0x0,0x0,0x7f80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f80,0x0,0x0,0x100000,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff80,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[29];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public CssParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public CssParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new CssParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 334; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 334; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CssParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CssParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 334; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 334; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CssParser(CssParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 334; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CssParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 334; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[155];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 334; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 155; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 29; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
