#ifndef INPUT_SCANCODE_H
#define INPUT_SCANCODE_H

enum Scancode {
	SCANCODE_EXTENDED   = 0xE000,
	SCANCODE_RELEASE    = 0x80,

	SCANCODE_TILDE  = 0x29,
	SCANCODE_1  = 0x02,
	SCANCODE_2  = 0x03,
	SCANCODE_3  = 0x04,
	SCANCODE_4  = 0x05,
	SCANCODE_5  = 0x06,
	SCANCODE_6  = 0x07,
	SCANCODE_7  = 0x08,
	SCANCODE_8  = 0x09,
	SCANCODE_9  = 0x0A,
	SCANCODE_0  = 0x0B,
	SCANCODE_MINUS  = 0x0C,
	SCANCODE_EQUALS = 0x0D,
	SCANCODE_BACKSPACE  = 0x0E,

	SCANCODE_TAB    = 0x0F,
	SCANCODE_Q  = 0x10,
	SCANCODE_W  = 0x11,
	SCANCODE_E  = 0x12,
	SCANCODE_R  = 0x13,
	SCANCODE_T  = 0x14,
	SCANCODE_Y  = 0x15,
	SCANCODE_U  = 0x16,
	SCANCODE_I  = 0x17,
	SCANCODE_O  = 0x18,
	SCANCODE_P  = 0x19,
	SCANCODE_OPENBRACE  = 0x1A,
	SCANCODE_CLOSEBRACE = 0x1B,
	SCANCODE_BACKSLASH  = 0x2B,

	SCANCODE_CAPSLOCK   = 0x3A,
	SCANCODE_A  = 0x1E,
	SCANCODE_S  = 0x1F,
	SCANCODE_D  = 0x20,
	SCANCODE_F  = 0x21,
	SCANCODE_G  = 0x22,
	SCANCODE_H  = 0x23,
	SCANCODE_J  = 0x24,
	SCANCODE_K  = 0x25,
	SCANCODE_L  = 0x26,
	SCANCODE_SEMICOLON  = 0x27,
	SCANCODE_QUOTE  = 0x28,
	SCANCODE_ENTER  = 0x1C,

	SCANCODE_LSHIFT = 0x2A,
	SCANCODE_Z  = 0x2C,
	SCANCODE_X  = 0x2D,
	SCANCODE_C  = 0x2E,
	SCANCODE_V  = 0x2F,
	SCANCODE_B  = 0x30,
	SCANCODE_N  = 0x31,
	SCANCODE_M  = 0x32,
	SCANCODE_COMMA  = 0x33,
	SCANCODE_FULLSTOP   = 0x34,
	SCANCODE_SLASH  = 0x35,
	/* SCANCODE_RSHIFT = 0x36, */

	SCANCODE_LCTRL  = 0x1D,
	SCANCODE_LALT   = 0x38,
	SCANCODE_SPACE  = 0x39,
	SCANCODE_RALT   = 0x38|SCANCODE_EXTENDED,
	SCANCODE_RCTRL  = 0x1D|SCANCODE_EXTENDED,
	SCANCODE_INSERT = 0x52|SCANCODE_EXTENDED,
	SCANCODE_DELETE = 0x53|SCANCODE_EXTENDED,
	SCANCODE_HOME   = 0x47|SCANCODE_EXTENDED,
	SCANCODE_END    = 0x4F|SCANCODE_EXTENDED,
	SCANCODE_PGUP   = 0x49|SCANCODE_EXTENDED,
	SCANCODE_PGDN   = 0x51|SCANCODE_EXTENDED,
	SCANCODE_LEFT   = 0x4B|SCANCODE_EXTENDED,
	SCANCODE_UP     = 0x48|SCANCODE_EXTENDED,
	SCANCODE_DOWN   = 0x50|SCANCODE_EXTENDED,
	SCANCODE_RIGHT  = 0x4D|SCANCODE_EXTENDED,

	SCANCODE_NUMLOCK    = 0x45,
	SCANCODE_KEYPAD_7   = 0x47,
	SCANCODE_KEYPAD_4   = 0x4B,
	SCANCODE_KEYPAD_1   = 0x4F,
	SCANCODE_KEYPAD_SLASH   = 0x35|SCANCODE_EXTENDED,
	SCANCODE_KEYPAD_8   = 0x48,
	SCANCODE_KEYPAD_5   = 0x4C,
	SCANCODE_KEYPAD_2   = 0x50,
	SCANCODE_KEYPAD_0   = 0x52,
	SCANCODE_KEYPAD_ASTERISK    = 0x37,
	SCANCODE_KEYPAD_9   = 0x49,
	SCANCODE_KEYPAD_6   = 0x4D,
	SCANCODE_KEYPAD_3   = 0x51,
	SCANCODE_KEYPAD_DELETE  = 0x53,
	SCANCODE_KEYPAD_MINUS   = 0x4A,
	SCANCODE_KEYPAD_PLUS    = 0x4E,
	SCANCODE_KEYPAD_ENTER   = 0x1C|SCANCODE_EXTENDED,

	SCANCODE_ESCAPE = 0x01,
	SCANCODE_F1     = 0x3B,
	SCANCODE_F2     = 0x3C,
	SCANCODE_F3     = 0x3D,
	SCANCODE_F4     = 0x3E,
	SCANCODE_F5     = 0x3F,
	SCANCODE_F6     = 0x40,
	SCANCODE_F7     = 0x41,
	SCANCODE_F8     = 0x42,
	SCANCODE_F9     = 0x43,
	SCANCODE_F10    = 0x44,
	SCANCODE_F11    = 0x57,
	SCANCODE_F12    = 0x58,

	SCANCODE_PRINTSCREEN    = 0x37|SCANCODE_EXTENDED,
	SCANCODE_SYSREQUEST = 0x54,
	SCANCODE_SCROLLLOCK = 0x46,
	/* SCANCODE_PAUSE   = e1-1d-45, */
	SCANCODE_BREAK  = 0x46|SCANCODE_EXTENDED,
	SCANCODE_LWIN   = 0x5B|SCANCODE_EXTENDED,
	SCANCODE_RWIN   = 0x5C|SCANCODE_EXTENDED,
	SCANCODE_MENU   = 0x5D|SCANCODE_EXTENDED,
	SCANCODE_SLEEP  = 0x5F|SCANCODE_EXTENDED,
	SCANCODE_POWER  = 0x5E|SCANCODE_EXTENDED,
	SCANCODE_WAKE   = 0x63|SCANCODE_EXTENDED,

	SCANCODE_MOUSE_ZAXIS = 0x7F,
	SCANCODE_MOUSE_LMB = 0x7E,
	SCANCODE_MOUSE_RMB = 0x7D
};

#endif
