/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.sf.sdedit.Constants;
import net.sf.sdedit.ui.G2DGraphicsDevice;

public class ImageGraphicsDevice
extends G2DGraphicsDevice
implements Constants {
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private Image image;
    private boolean antialias;

    public ImageGraphicsDevice() {
        this(true);
    }

    public ImageGraphicsDevice(boolean antialias) {
        this.antialias = antialias;
    }

    public Image getImage() {
        return this.image;
    }

    public void writeToStream(String type, OutputStream stream) throws IOException {
        this.drawAll();
        ImageIO.write((RenderedImage)((Object)this.image), type, stream);
    }

    public void saveImage(String type, String fileName) throws IOException {
        this.saveImage(type, new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImage(String type, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            this.writeToStream(type, os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    @Override
    protected Graphics2D createDummyGraphics() {
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g2d = (Graphics2D)((Image)img).getGraphics();
        Font font = this.getFont();
        g2d.setFont(font);
        return g2d;
    }

    @Override
    protected Graphics2D createGraphics() {
        this.image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g2d = (Graphics2D)this.image.getGraphics();
        if (this.antialias) {
            g2d.setRenderingHints(AALIAS);
        }
        g2d.setFont(this.getFont());
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        return g2d;
    }
}

