/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttConstraintMode;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Moment;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskInstant;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public class ComplementBeforeOrAfterOrAtTaskStartOrEnd
implements Something {
    private static final int POS_NB1 = 0;
    private static final int POS_WORKING1 = 1;
    private static final int POS_DAY_OR_WEEK1 = 2;
    private static final int POS_NB2 = 3;
    private static final int POS_WORKING2 = 4;
    private static final int POS_DAY_OR_WEEK2 = 5;
    private static final int POS_BEFORE_OR_AFTER = 6;
    private static final int POS_CODE_OTHER = 7;
    private static final int POS_START_OR_END = 8;

    @Override
    public IRegex toRegex(String suffix) {
        return new RegexLeaf("COMPLEMENT" + suffix, "(?:at|with|after|(\\d+)[%s]+(working[%s]+)?(day|week)s?(?:[%s]+and[%s]+(\\d+)[%s]+(working[%s]+)?(day|week)s?)?[%s]+(before|after))[%s]+\\[([^\\[\\]]+?)\\].?s[%s]+(start|end)");
    }

    public Failable<TaskInstant> getMe(GanttDiagram system, RegexResult arg, String suffix) {
        String code = arg.get("COMPLEMENT" + suffix, 7);
        String startOrEnd = arg.get("COMPLEMENT" + suffix, 8);
        Moment task = system.getExistingMoment(code);
        if (task == null) {
            return Failable.error("No such task " + code);
        }
        TaskInstant result = new TaskInstant(task, TaskAttribute.fromString(startOrEnd));
        String nb1 = arg.get("COMPLEMENT" + suffix, 0);
        if (nb1 != null) {
            int factor1 = arg.get("COMPLEMENT" + suffix, 2).startsWith("w") ? system.daysInWeek() : 1;
            int days1 = Integer.parseInt(nb1) * factor1;
            String nb2 = arg.get("COMPLEMENT" + suffix, 3);
            int days2 = 0;
            if (nb2 != null) {
                int factor2 = arg.get("COMPLEMENT" + suffix, 5).startsWith("w") ? system.daysInWeek() : 1;
                days2 = Integer.parseInt(nb2) * factor2;
            }
            int delta = days1 + days2;
            if ("before".equalsIgnoreCase(arg.get("COMPLEMENT" + suffix, 6))) {
                delta = -delta;
            }
            boolean working = arg.get("COMPLEMENT" + suffix, 1) != null || arg.get("COMPLEMENT" + suffix, 4) != null;
            GanttConstraintMode mode = working ? GanttConstraintMode.DO_NOT_COUNT_CLOSE_DAY : GanttConstraintMode.IGNORE_CALENDAR;
            result = result.withDelta(delta, mode, system.getDefaultPlan());
        }
        return Failable.ok(result);
    }
}

