/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.Addresses;
import org.openstreetmap.josm.data.validation.tests.ApiCapabilitiesTest;
import org.openstreetmap.josm.data.validation.tests.BarriersEntrances;
import org.openstreetmap.josm.data.validation.tests.Coastlines;
import org.openstreetmap.josm.data.validation.tests.ConditionalKeys;
import org.openstreetmap.josm.data.validation.tests.ConnectivityRelations;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.data.validation.tests.CycleDetector;
import org.openstreetmap.josm.data.validation.tests.DirectionNodes;
import org.openstreetmap.josm.data.validation.tests.DuplicateNode;
import org.openstreetmap.josm.data.validation.tests.DuplicateRelation;
import org.openstreetmap.josm.data.validation.tests.DuplicateWay;
import org.openstreetmap.josm.data.validation.tests.DuplicatedWayNodes;
import org.openstreetmap.josm.data.validation.tests.Highways;
import org.openstreetmap.josm.data.validation.tests.InternetTags;
import org.openstreetmap.josm.data.validation.tests.Lanes;
import org.openstreetmap.josm.data.validation.tests.LongSegment;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.data.validation.tests.NameMismatch;
import org.openstreetmap.josm.data.validation.tests.OpeningHourTest;
import org.openstreetmap.josm.data.validation.tests.OverlappingWays;
import org.openstreetmap.josm.data.validation.tests.PowerLines;
import org.openstreetmap.josm.data.validation.tests.PublicTransportRouteTest;
import org.openstreetmap.josm.data.validation.tests.RelationChecker;
import org.openstreetmap.josm.data.validation.tests.RightAngleBuildingTest;
import org.openstreetmap.josm.data.validation.tests.SelfIntersectingWay;
import org.openstreetmap.josm.data.validation.tests.SharpAngles;
import org.openstreetmap.josm.data.validation.tests.SimilarNamedWays;
import org.openstreetmap.josm.data.validation.tests.TagChecker;
import org.openstreetmap.josm.data.validation.tests.TurnrestrictionTest;
import org.openstreetmap.josm.data.validation.tests.UnclosedWays;
import org.openstreetmap.josm.data.validation.tests.UnconnectedWays;
import org.openstreetmap.josm.data.validation.tests.UntaggedNode;
import org.openstreetmap.josm.data.validation.tests.UntaggedWay;
import org.openstreetmap.josm.data.validation.tests.WayConnectedToArea;
import org.openstreetmap.josm.data.validation.tests.WronglyOrderedWays;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Stopwatch;
import org.openstreetmap.josm.tools.Utils;

public final class OsmValidator {
    private static volatile ValidatorLayer errorLayer;
    private static double griddetail;
    private static final SortedMap<String, String> ignoredErrors;
    private static final Collection<Class<? extends Test>> allTests;
    private static final Map<String, Test> allTestsMap;
    private static final Class<Test>[] CORE_TEST_CLASSES;
    private static boolean testsInitialized;

    private OsmValidator() {
    }

    public static void addTest(Class<? extends Test> testClass) {
        allTests.add(testClass);
        try {
            allTestsMap.put(testClass.getName(), testClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            Logging.error(e);
        }
    }

    public static boolean removeTest(Class<? extends Test> testClass) {
        boolean removed = false;
        if (!Arrays.asList(CORE_TEST_CLASSES).contains(testClass)) {
            removed = allTests.remove(testClass);
            allTestsMap.remove(testClass.getName());
        }
        return removed;
    }

    public static void initialize() {
        OsmValidator.initializeGridDetail();
        OsmValidator.loadIgnoredErrors();
    }

    public static String getValidatorDir() {
        File dir = new File(Config.getDirs().getUserDataDirectory(true), "validator");
        try {
            return dir.getAbsolutePath();
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, null, e);
            return dir.getPath();
        }
    }

    private static void loadIgnoredErrors() {
        ignoredErrors.clear();
        if (Boolean.TRUE.equals(ValidatorPrefHelper.PREF_USE_IGNORE.get())) {
            Config.getPref().getListOfMaps("validator.ignorelist").forEach(ignoredErrors::putAll);
            Path path = Paths.get(OsmValidator.getValidatorDir(), new String[0]).resolve("ignorederrors");
            try {
                if (path.toFile().exists()) {
                    try {
                        TreeSet<String> treeSet = new TreeSet<String>(Files.readAllLines(path, StandardCharsets.UTF_8));
                        treeSet.forEach(ignore -> ignoredErrors.putIfAbsent((String)ignore, ""));
                        OsmValidator.removeLegacyEntries(true);
                        OsmValidator.saveIgnoredErrors();
                        Files.deleteIfExists(path);
                    }
                    catch (FileNotFoundException e) {
                        Logging.debug(Logging.getErrorMessage(e));
                    }
                    catch (IOException e) {
                        Logging.error(e);
                    }
                }
            }
            catch (SecurityException e) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to load ignored errors", e);
            }
            OsmValidator.removeLegacyEntries(Config.getPref().get("validator.ignorelist.version").isEmpty());
        }
    }

    private static void removeLegacyEntries(boolean force) {
        boolean wasChanged = OsmValidator.removeLegacyEntry(force, true, "3000");
        if (wasChanged |= OsmValidator.removeLegacyEntry(force, false, "3701")) {
            OsmValidator.saveIgnoredErrors();
        }
    }

    private static boolean removeLegacyEntry(boolean force, boolean keep, String prefix) {
        boolean wasChanged = false;
        if (force) {
            Iterator<Map.Entry<String, String>> iter = ignoredErrors.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                if (!entry.getKey().startsWith(prefix + "_")) continue;
                Logging.warn(I18n.tr("Cannot handle ignore list entry {0}", entry));
                iter.remove();
                wasChanged = true;
            }
        }
        String legacyEntry = (String)ignoredErrors.remove(prefix);
        if (keep && legacyEntry != null) {
            if (!legacyEntry.isEmpty()) {
                OsmValidator.addIgnoredError(prefix + "_" + legacyEntry, legacyEntry);
            }
            wasChanged = true;
        }
        return wasChanged;
    }

    public static void addIgnoredError(String s) {
        OsmValidator.addIgnoredError(s, "");
    }

    public static void addIgnoredError(String s, String description) {
        if (description == null) {
            description = "";
        }
        ignoredErrors.put(s, description);
    }

    static void cleanupIgnoredErrors() {
        Map<String, String> tmap;
        if (ignoredErrors.size() > 1) {
            ArrayList<String> toRemove = new ArrayList<String>();
            Iterator<Map.Entry<String, String>> iter = ignoredErrors.entrySet().iterator();
            String lastKey = iter.next().getKey();
            while (iter.hasNext()) {
                String currKey = iter.next().getKey();
                if (currKey.startsWith(lastKey) && OsmValidator.sameCode(currKey, lastKey)) {
                    toRemove.add(currKey);
                    continue;
                }
                lastKey = currKey;
            }
            toRemove.forEach(ignoredErrors::remove);
        }
        if (!(tmap = OsmValidator.buildIgnore(OsmValidator.buildJTreeList())).isEmpty()) {
            ignoredErrors.clear();
            ignoredErrors.putAll(tmap);
        }
    }

    private static boolean sameCode(String key1, String key2) {
        return OsmValidator.extractCodeFromIgnoreKey(key1).equals(OsmValidator.extractCodeFromIgnoreKey(key2));
    }

    private static String extractCodeFromIgnoreKey(String key) {
        int lenCode = 0;
        for (int i = 0; i < key.length() && key.charAt(i) >= '0' && key.charAt(i) <= '9'; ++i) {
            ++lenCode;
        }
        return key.substring(0, lenCode);
    }

    public static boolean hasIgnoredError(String s) {
        return ignoredErrors.containsKey(s);
    }

    public static SortedMap<String, String> getIgnoredErrors() {
        return ignoredErrors;
    }

    /*
     * WARNING - void declaration
     */
    public static JTree buildJTreeList() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(I18n.tr("Ignore list", new Object[0]));
        Pattern elemId1Pattern = Pattern.compile(":([rwn])_");
        Pattern elemId2Pattern = Pattern.compile("^[0-9]+$");
        for (Map.Entry<String, String> e : ignoredErrors.entrySet()) {
            DefaultMutableTreeNode trunk;
            String key = e.getKey();
            String description = e.getValue();
            ArrayList<CallSite> ignoredElementList = new ArrayList<CallSite>();
            String[] osmobjects = elemId1Pattern.split(key, -1);
            for (int i = 1; i < osmobjects.length; ++i) {
                String string;
                int index;
                String string2 = osmobjects[i];
                if (!elemId2Pattern.matcher(string2).matches() || (index = key.indexOf(string = "_" + string2)) < key.lastIndexOf(93)) continue;
                char type = key.charAt(index - 1);
                ignoredElementList.add((CallSite)((Object)(type + string)));
            }
            for (String string : ignoredElementList) {
                key = key.replace(":" + string, "");
            }
            if (!Utils.isEmpty(description)) {
                trunk = OsmValidator.inTree(root, description);
                DefaultMutableTreeNode defaultMutableTreeNode = OsmValidator.inTree(trunk, key);
                trunk.add(defaultMutableTreeNode);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = trunk = OsmValidator.inTree(root, key);
            }
            if (!ignoredElementList.isEmpty()) {
                void var10_11;
                String item = ignoredElementList.size() == 1 ? (String)ignoredElementList.iterator().next() : ignoredElementList.toString();
                var10_11.add(new DefaultMutableTreeNode(item));
            }
            root.add(trunk);
        }
        return new JTree(root);
    }

    private static DefaultMutableTreeNode inTree(DefaultMutableTreeNode root, String name) {
        Enumeration<TreeNode> trunks = root.children();
        while (trunks.hasMoreElements()) {
            DefaultMutableTreeNode trunk;
            TreeNode ttrunk = trunks.nextElement();
            if (!(ttrunk instanceof DefaultMutableTreeNode) || !name.equals((trunk = (DefaultMutableTreeNode)ttrunk).getUserObject())) continue;
            return trunk;
        }
        return new DefaultMutableTreeNode(name);
    }

    public static Map<String, String> buildIgnore(JTree tree) {
        TreeModel model = tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        return OsmValidator.buildIgnore(model, root);
    }

    private static Map<String, String> buildIgnore(TreeModel model, DefaultMutableTreeNode node) {
        HashMap<String, String> rHashMap = new HashMap<String, String>();
        for (int i = 0; i < model.getChildCount(node); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)model.getChild(node, i);
            if (model.getChildCount(child) == 0) {
                String key = node.getUserObject().toString();
                String description = !model.getRoot().equals(node) ? ((DefaultMutableTreeNode)node.getParent()).getUserObject().toString() : key;
                if (I18n.tr("Ignore list", new Object[0]).equals(description)) {
                    description = "";
                }
                if (!key.matches("^-?[0-9]+(_.*|$)")) {
                    description = key;
                    key = "";
                }
                String item = child.getUserObject().toString();
                Object entry = null;
                if (item.matches("^\\[([rwn])_.*")) {
                    entry = key + ":" + item.substring(1, item.lastIndexOf(93)).replace(", ", ":");
                } else if (item.matches("^([rwn])_.*")) {
                    entry = key + ":" + item;
                } else if (item.matches("^-?[0-9]+(_.*|)$")) {
                    entry = item;
                }
                if (entry != null) {
                    rHashMap.put((String)entry, description);
                    continue;
                }
                Logging.warn("ignored unexpected item in validator ignore list management dialog:'" + item + "'");
                continue;
            }
            rHashMap.putAll(OsmValidator.buildIgnore(model, child));
        }
        return rHashMap;
    }

    public static void resetErrorList() {
        OsmValidator.saveIgnoredErrors();
        Config.getPref().putListOfMaps("validator.ignorelist", null);
        OsmValidator.initialize();
    }

    public static void saveIgnoredErrors() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        OsmValidator.cleanupIgnoredErrors();
        ignoredErrors.remove("3000");
        ignoredErrors.remove("3701");
        list.add(ignoredErrors);
        int i = 0;
        while (i < list.size()) {
            if (Utils.isEmpty((Map)list.get(i))) {
                list.remove(i);
                continue;
            }
            ++i;
        }
        if (list.isEmpty()) {
            list = null;
        }
        Config.getPref().putListOfMaps("validator.ignorelist", list);
        Config.getPref().put("validator.ignorelist.version", "2");
    }

    public static synchronized void initializeErrorLayer() {
        if (errorLayer == null && Boolean.TRUE.equals(ValidatorPrefHelper.PREF_LAYER.get())) {
            errorLayer = new ValidatorLayer();
            MainApplication.getLayerManager().addLayer(errorLayer);
        }
    }

    public static synchronized void resetErrorLayer() {
        errorLayer = null;
    }

    public static SortedMap<String, Test> getAllTestsMap() {
        OsmValidator.applyPrefs(allTestsMap, false);
        OsmValidator.applyPrefs(allTestsMap, true);
        return new TreeMap<String, Test>(allTestsMap);
    }

    public static <T extends Test> T getTest(Class<T> testClass) {
        if (testClass == null) {
            return null;
        }
        return (T)allTestsMap.get(testClass.getName());
    }

    private static void applyPrefs(Map<String, Test> tests, boolean beforeUpload) {
        for (String testName : Config.getPref().getList(beforeUpload ? "validator.skipBeforeUpload" : "validator.skip")) {
            Test test = tests.get(testName);
            if (test == null) continue;
            if (beforeUpload) {
                test.testBeforeUpload = false;
                continue;
            }
            test.enabled = false;
        }
    }

    public static Collection<Test> getTests() {
        return OsmValidator.getAllTestsMap().values();
    }

    public static Collection<Test> getEnabledTests(boolean beforeUpload) {
        Collection<Test> enabledTests = OsmValidator.getTests();
        for (Test t : new ArrayList<Test>(enabledTests)) {
            if (beforeUpload ? t.testBeforeUpload : t.enabled) continue;
            enabledTests.remove(t);
        }
        return enabledTests;
    }

    public static Collection<Class<? extends Test>> getAllAvailableTestClasses() {
        return Collections.unmodifiableCollection(allTests);
    }

    public static void initializeGridDetail() {
        String code = ProjectionRegistry.getProjection().toCode();
        griddetail = Arrays.asList(ProjectionPreference.wgs84.allCodes()).contains(code) ? 10000.0 : (Arrays.asList(ProjectionPreference.mercator.allCodes()).contains(code) ? 0.01 : (Arrays.asList(ProjectionPreference.lambert.allCodes()).contains(code) ? 0.1 : 1.0));
    }

    public static double getGridDetail() {
        return griddetail;
    }

    public static synchronized void initializeTests() {
        if (!testsInitialized) {
            String message = "Initializing validator tests";
            Logging.debug("Initializing validator tests");
            Stopwatch stopwatch = Stopwatch.createStarted();
            OsmValidator.initializeTests(OsmValidator.getTests());
            testsInitialized = true;
            Logging.debug(stopwatch.toString("Initializing validator tests"));
        }
    }

    public static void initializeTests(Collection<? extends Test> allTests) {
        for (Test test : allTests) {
            try {
                if (!test.enabled) continue;
                test.initialize();
            }
            catch (Exception e) {
                String message = I18n.tr("Error initializing test {0}:\n {1}", test.getClass().getSimpleName(), e);
                Logging.error(message);
                if (GraphicsEnvironment.isHeadless()) continue;
                GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), message, I18n.tr("Error", new Object[0]), 0));
            }
        }
    }

    public static Map<Severity, Map<String, Map<String, List<TestError>>>> getErrorsBySeverityMessageDescription(Collection<TestError> errors, Predicate<? super TestError> filterToUse) {
        return errors.stream().filter(filterToUse).collect(Collectors.groupingBy(TestError::getSeverity, () -> new EnumMap(Severity.class), Collectors.groupingBy(TestError::getMessage, () -> new TreeMap(AlphanumComparator.getInstance()), Collectors.groupingBy(e -> e.getDescription() == null ? "" : e.getDescription(), () -> new TreeMap(AlphanumComparator.getInstance()), Collectors.toList()))));
    }

    static void clearIgnoredErrors() {
        ignoredErrors.clear();
    }

    static {
        ignoredErrors = new TreeMap<String, String>();
        allTests = new ArrayList<Class<? extends Test>>();
        allTestsMap = new HashMap<String, Test>();
        for (Class<Test> testClass : CORE_TEST_CLASSES = new Class[]{DuplicateNode.class, OverlappingWays.class, UntaggedNode.class, UntaggedWay.class, SelfIntersectingWay.class, DuplicatedWayNodes.class, CrossingWays.Ways.class, CrossingWays.Boundaries.class, CrossingWays.SelfCrossing.class, SimilarNamedWays.class, Coastlines.class, WronglyOrderedWays.class, UnclosedWays.class, TagChecker.class, UnconnectedWays.UnconnectedHighways.class, UnconnectedWays.UnconnectedRailways.class, UnconnectedWays.UnconnectedWaterways.class, UnconnectedWays.UnconnectedNaturalOrLanduse.class, UnconnectedWays.UnconnectedPower.class, DuplicateWay.class, NameMismatch.class, MultipolygonTest.class, RelationChecker.class, TurnrestrictionTest.class, DuplicateRelation.class, WayConnectedToArea.class, PowerLines.class, Addresses.class, Highways.class, BarriersEntrances.class, OpeningHourTest.class, MapCSSTagChecker.class, Lanes.class, ConditionalKeys.class, InternetTags.class, ApiCapabilitiesTest.class, LongSegment.class, PublicTransportRouteTest.class, SharpAngles.class, ConnectivityRelations.class, DirectionNodes.class, RightAngleBuildingTest.class, CycleDetector.class}) {
            OsmValidator.addTest(testClass);
        }
    }
}

