/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.bridge;

import java.util.Arrays;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnObserver;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphObserver;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.visualization.GraphLimits;
import org.gephi.visualization.VizArchitecture;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.model.edge.EdgeModeler;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.model.node.NodeModeler;
import org.gephi.visualization.octree.Octree;
import org.gephi.visualization.opengl.AbstractEngine;
import org.gephi.visualization.text.TextManager;
import org.gephi.visualization.text.TextModelImpl;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class DataBridge
implements VizArchitecture {
    protected static final long ONEOVERPHI = 106039L;
    protected AbstractEngine engine;
    protected GraphController controller;
    protected TextManager textManager;
    protected ColumnObserver[] nodeColumnObservers;
    protected ColumnObserver[] edgeColumnObservers;
    protected int nodeColumnHashCode;
    protected int edgeColumnHashCode;
    protected GraphLimits limits;
    protected GraphModel graphModel;
    protected Graph graph;
    protected GraphObserver observer;
    protected NodeModel[] nodes;
    protected EdgeModel[] edges;
    private VizConfig vizConfig;
    private TextModelImpl textModel;

    @Override
    public void initArchitecture() {
        this.engine = VizController.getInstance().getEngine();
        this.controller = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.vizConfig = VizController.getInstance().getVizConfig();
        this.limits = VizController.getInstance().getLimits();
        this.textManager = VizController.getInstance().getTextManager();
    }

    public synchronized NodeModel[] getNodeModelsForNodes(Node[] n) {
        if (n == null) {
            return null;
        }
        NodeModel[] models = new NodeModel[n.length];
        for (int i = 0; i < n.length; ++i) {
            int storeId = n[i].getStoreId();
            models[i] = storeId < this.nodes.length ? this.nodes[n[i].getStoreId()] : null;
        }
        return models;
    }

    public synchronized EdgeModel[] getEdgeModelsForEdges(Edge[] e) {
        if (e == null) {
            return null;
        }
        EdgeModel[] models = new EdgeModel[e.length];
        for (int i = 0; i < e.length; ++i) {
            int storeId = e[i].getStoreId();
            models[i] = storeId < this.edges.length ? this.edges[e[i].getStoreId()] : null;
        }
        return models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateWorld() {
        Octree octree;
        boolean force = false;
        boolean visibleViewChanged = false;
        if (this.graphModel != null) {
            this.graphModel.getGraph().readLock();
            try {
                visibleViewChanged = this.graph.getView() != this.graphModel.getVisibleView();
            }
            finally {
                this.graphModel.getGraph().readUnlockAll();
            }
        }
        if (visibleViewChanged || this.observer != null && this.observer.isDestroyed()) {
            this.graphModel.getGraph().writeLock();
            try {
                if (this.observer != null && !this.observer.isDestroyed()) {
                    this.observer.destroy();
                }
                this.observer = null;
                this.graph = this.graphModel.getGraphVisible();
                this.observer = this.graphModel.createGraphObserver(this.graph, false);
                force = true;
            }
            finally {
                this.graphModel.getGraph().writeUnlock();
                this.graphModel.getGraph().readUnlockAll();
            }
        }
        if (force || this.observer != null && (this.observer.isNew() || this.observer.hasGraphChanged()) || this.hasColumnsChanged()) {
            block33: {
                this.graph.readLock();
                try {
                    if (!this.graph.getView().isDestroyed()) {
                        boolean isView;
                        if (this.observer.isNew()) {
                            this.observer.hasGraphChanged();
                        }
                        NodeModeler nodeModeler = this.engine.getNodeModeler();
                        EdgeModeler edgeModeler = this.engine.getEdgeModeler();
                        Octree octree2 = this.engine.getOctree();
                        int removedNodes = 0;
                        int addedNodes = 0;
                        int removedEdges = 0;
                        int addedEdges = 0;
                        GraphView graphView = this.graph.getView();
                        boolean bl = isView = !graphView.isMainView();
                        if (!graphView.isDestroyed()) {
                            for (int i = 0; i < this.nodes.length; ++i) {
                                NodeModel node = this.nodes[i];
                                if (node == null || node.getNode().getStoreId() != -1 && (!isView || this.graph.contains(node.getNode()))) continue;
                                octree2.removeNode(node);
                                this.nodes[i] = null;
                                ++removedNodes;
                            }
                            for (NodeModel node : this.graph.getNodes()) {
                                NodeModel model;
                                int id = node.getStoreId();
                                if (id >= this.nodes.length || this.nodes[id] == null) {
                                    this.growNodes(id);
                                    model = nodeModeler.initModel((Node)node);
                                    octree2.addNode(model);
                                    this.nodes[id] = model;
                                    ++addedNodes;
                                } else {
                                    model = this.nodes[id];
                                }
                                this.textManager.refreshNode(this.graph, model, this.textModel);
                            }
                            for (int i = 0; i < this.edges.length; ++i) {
                                NodeModel targetModel;
                                EdgeModel edge = this.edges[i];
                                if (edge == null || edge.getEdge().getStoreId() != -1 && (!isView || this.graph.contains(edge.getEdge()))) continue;
                                int sourceId = edge.getEdge().getSource().getStoreId();
                                int targetId = edge.getEdge().getTarget().getStoreId();
                                NodeModel sourceModel = sourceId == -1 ? null : this.nodes[sourceId];
                                NodeModel nodeModel = targetModel = targetId == -1 ? null : this.nodes[targetId];
                                if (sourceModel != null) {
                                    sourceModel.removeEdge(edge);
                                }
                                if (targetModel != null && sourceModel != targetModel) {
                                    targetModel.removeEdge(edge);
                                }
                                this.edges[i] = null;
                                ++removedEdges;
                            }
                            float minWeight = Float.MAX_VALUE;
                            float maxWeight = Float.MIN_VALUE;
                            for (Edge edge : this.graph.getEdges()) {
                                EdgeModel model;
                                int id = edge.getStoreId();
                                if (id >= this.edges.length || this.edges[id] == null) {
                                    this.growEdges(id);
                                    NodeModel sourceModel = this.nodes[edge.getSource().getStoreId()];
                                    NodeModel targetModel = this.nodes[edge.getTarget().getStoreId()];
                                    model = edgeModeler.initModel(edge, sourceModel, targetModel);
                                    sourceModel.addEdge(model);
                                    if (targetModel != sourceModel) {
                                        targetModel.addEdge(model);
                                    }
                                    this.edges[id] = model;
                                    ++addedEdges;
                                } else {
                                    model = this.edges[id];
                                }
                                float w = (float)edge.getWeight(graphView);
                                model.setWeight(w);
                                minWeight = Math.min(w, minWeight);
                                maxWeight = Math.max(w, maxWeight);
                                this.textManager.refreshEdge(this.graph, model, this.textModel);
                            }
                            if (!isView) {
                                this.limits.setMaxWeight(maxWeight);
                                this.limits.setMinWeight(minWeight);
                            }
                        }
                        break block33;
                    }
                    boolean nodeModeler = false;
                    return nodeModeler;
                }
                catch (Throwable e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                finally {
                    this.graph.readUnlockAll();
                }
            }
            return true;
        }
        if (this.observer == null && !(octree = this.engine.getOctree()).isEmpty()) {
            octree.clear();
        }
        return false;
    }

    private boolean hasColumnsChanged() {
        if (this.nodeColumnObservers != null && this.edgeColumnObservers != null) {
            Object[] nodeColumns = this.textModel.getNodeTextColumns();
            int nodeCode = Arrays.hashCode(nodeColumns);
            if (nodeCode != this.nodeColumnHashCode) {
                this.refreshNodeColumns(this.textModel);
                return true;
            }
            Object[] edgeColumns = this.textModel.getEdgeTextColumns();
            int edgeCode = Arrays.hashCode(edgeColumns);
            if (edgeCode != this.edgeColumnHashCode) {
                this.refreshEdgeColumns(this.textModel);
                return true;
            }
            for (ColumnObserver c : this.nodeColumnObservers) {
                if (!c.hasColumnChanged()) continue;
                return true;
            }
            for (ColumnObserver c : this.edgeColumnObservers) {
                if (!c.hasColumnChanged()) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void reset() {
        this.graphModel = this.controller.getGraphModel();
        if (this.graphModel != null) {
            this.graph = this.graphModel.getGraphVisible();
            this.graph.writeLock();
        }
        try {
            if (this.observer != null && (this.graphModel == null || this.observer.getGraph() != this.graph)) {
                if (!this.observer.isDestroyed()) {
                    this.observer.destroy();
                }
                this.observer = null;
            }
        }
        finally {
            if (this.graphModel != null) {
                this.graph.writeUnlock();
                this.graph.readUnlockAll();
            }
        }
        if (this.nodeColumnObservers != null) {
            for (ColumnObserver c : this.nodeColumnObservers) {
                if (c.isDestroyed()) continue;
                c.destroy();
            }
            this.nodeColumnObservers = null;
        }
        if (this.edgeColumnObservers != null) {
            for (ColumnObserver c : this.edgeColumnObservers) {
                if (c.isDestroyed()) continue;
                c.destroy();
            }
            this.edgeColumnObservers = null;
        }
        this.nodes = new NodeModel[10];
        this.edges = new EdgeModel[10];
        Octree octree = this.engine.getOctree();
        if (!octree.isEmpty()) {
            octree.clear();
        }
        if (this.graphModel != null) {
            this.observer = this.graphModel.createGraphObserver(this.graph, false);
            this.textModel = VizController.getInstance().getVizModel().getTextModel();
            this.refreshNodeColumns(this.textModel);
            this.refreshEdgeColumns(this.textModel);
        }
    }

    private void refreshNodeColumns(TextModelImpl textModelImpl) {
        if (this.nodeColumnObservers != null) {
            for (ColumnObserver c : this.nodeColumnObservers) {
                if (c.isDestroyed()) continue;
                c.destroy();
            }
            this.nodeColumnObservers = null;
        }
        Object[] nodeColumns = textModelImpl.getNodeTextColumns();
        this.nodeColumnHashCode = Arrays.hashCode(nodeColumns);
        this.nodeColumnObservers = new ColumnObserver[nodeColumns.length];
        for (int i = 0; i < nodeColumns.length; ++i) {
            this.nodeColumnObservers[i] = nodeColumns[i].createColumnObserver(false);
        }
    }

    private void refreshEdgeColumns(TextModelImpl textModelImpl) {
        if (this.edgeColumnObservers != null) {
            for (ColumnObserver c : this.edgeColumnObservers) {
                if (c.isDestroyed()) continue;
                c.destroy();
            }
            this.edgeColumnObservers = null;
        }
        Column[] edgeTextColumns = textModelImpl.getEdgeTextColumns();
        Object[] edgeColumns = Arrays.copyOf(edgeTextColumns, edgeTextColumns.length + 1);
        edgeColumns[edgeColumns.length - 1] = this.graphModel.getEdgeTable().getColumn("weight");
        this.edgeColumnHashCode = Arrays.hashCode(edgeColumns);
        this.edgeColumnObservers = new ColumnObserver[edgeColumns.length];
        for (int i = 0; i < edgeColumns.length; ++i) {
            this.edgeColumnObservers[i] = edgeColumns[i].createColumnObserver(false);
        }
    }

    public boolean isDirected() {
        return this.graphModel != null && !this.graphModel.isUndirected();
    }

    public Graph getGraph() {
        return this.graph;
    }

    private void growNodes(int index) {
        if (this.nodes == null) {
            this.nodes = new NodeModel[10];
        } else if (index >= this.nodes.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)this.nodes.length >>> 16, (long)(index + 1)), Integer.MAX_VALUE);
            NodeModel[] t = new NodeModel[newLength];
            System.arraycopy(this.nodes, 0, t, 0, this.nodes.length);
            this.nodes = t;
        }
    }

    private void growEdges(int index) {
        if (this.edges == null) {
            this.edges = new EdgeModel[10];
        } else if (index >= this.edges.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)this.edges.length >>> 16, (long)(index + 1)), Integer.MAX_VALUE);
            EdgeModel[] t = new EdgeModel[newLength];
            System.arraycopy(this.edges, 0, t, 0, this.edges.length);
            this.edges = t;
        }
    }
}

