/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.i18n;

import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import writer2latex.latex.i18n.ClassicI18n;
import writer2latex.latex.i18n.UnicodeTable;

public class UnicodeTableHandler
extends DefaultHandler {
    private Hashtable<String, UnicodeTable> tableSet;
    private UnicodeTable table;
    private String sSymbolSets;
    private boolean bGlobalReadThisSet;
    private boolean bReadThisSet;
    private int nGlobalFontencs = 0;
    private int nFontencs = 0;
    private boolean b8bit = false;

    public UnicodeTableHandler(Hashtable<String, UnicodeTable> tableSet, String sSymbolSets) {
        this.sSymbolSets = sSymbolSets;
        this.tableSet = tableSet;
    }

    @Override
    public void startElement(String nameSpace, String localName, String qName, Attributes attributes) {
        block11: {
            block17: {
                block15: {
                    char cProtect;
                    char c;
                    block16: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        if (!qName.equals("symbols")) break block10;
                                        this.table = new UnicodeTable(null);
                                        this.tableSet.put("root", this.table);
                                        break block11;
                                    }
                                    if (!qName.equals("symbol-set")) break block12;
                                    this.bReadThisSet = this.bGlobalReadThisSet = this.sSymbolSets.indexOf(attributes.getValue("name")) >= 0;
                                    this.nFontencs = this.nGlobalFontencs = ClassicI18n.readFontencs(attributes.getValue("fontenc"));
                                    break block11;
                                }
                                if (!qName.equals("special-symbol-set")) break block13;
                                this.table = new UnicodeTable(this.tableSet.get("root"));
                                this.tableSet.put(attributes.getValue("name"), this.table);
                                this.bReadThisSet = this.bGlobalReadThisSet = attributes.getValue("requires") == null || this.sSymbolSets.indexOf(attributes.getValue("requires")) >= 0;
                                this.b8bit = "true".equals(attributes.getValue("eight-bit"));
                                this.nFontencs = this.nGlobalFontencs = ClassicI18n.readFontencs(attributes.getValue("fontenc"));
                                break block11;
                            }
                            if (!qName.equals("symbol-subset")) break block14;
                            if (attributes.getValue("requires") != null) {
                                this.bReadThisSet = this.sSymbolSets.indexOf(attributes.getValue("requires")) >= 0;
                            }
                            this.nFontencs = ClassicI18n.readFontencs(attributes.getValue("fontenc"));
                            break block11;
                        }
                        if (!qName.equals("symbol")) break block15;
                        if (!this.bReadThisSet) break block11;
                        c = (char)Integer.parseInt(attributes.getValue("char"), 16);
                        String sEqChar = attributes.getValue("eq-char");
                        if (sEqChar == null) break block16;
                        char eqc = (char)Integer.parseInt(sEqChar, 16);
                        if (this.table.getCharType(eqc) != 3) {
                            this.table.addCharType(c, this.table.getCharType(eqc));
                        }
                        if (this.table.hasMathChar(eqc)) {
                            this.table.addMathChar(c, this.table.getMathChar(eqc));
                        }
                        if (this.table.hasTextChar(eqc)) {
                            this.table.addTextChar(c, this.table.getTextChar(eqc), this.table.getFontencs(eqc), this.table.getProtectChar(eqc));
                        }
                        break block11;
                    }
                    String sType = attributes.getValue("char-type");
                    String sMath = attributes.getValue("math");
                    String sText = attributes.getValue("text");
                    String sProtect = attributes.getValue("protect");
                    char c2 = cProtect = sProtect != null && sProtect.length() > 0 ? sProtect.charAt(0) : (char)'\u0000';
                    if (sType != null) {
                        this.table.addCharType(c, sType);
                    }
                    if (sMath != null) {
                        this.table.addMathChar(c, sMath);
                    }
                    if (sText == null) break block11;
                    this.table.addTextChar(c, sText, this.nFontencs, cProtect);
                    break block11;
                }
                if (!qName.equals("preserve-symbol")) break block17;
                if (!this.bReadThisSet) break block11;
                String sMode = attributes.getValue("mode");
                char c = (char)Integer.parseInt(attributes.getValue("char"), 16);
                this.table.addCharType(c, attributes.getValue("char-type"));
                if ("math".equals(sMode) || "both".equals(sMode)) {
                    this.table.addMathChar(c, Character.toString(c));
                }
                if (!"text".equals(sMode) && !"both".equals(sMode)) break block11;
                this.table.addTextChar(c, Character.toString(c), this.nFontencs, '\u0000');
                break block11;
            }
            if (qName.equals("preserve-symbols") && this.bReadThisSet) {
                String sMode = attributes.getValue("mode");
                String sType = attributes.getValue("char-type");
                char c1 = (char)Integer.parseInt(attributes.getValue("first-char"), 16);
                char c2 = (char)Integer.parseInt(attributes.getValue("last-char"), 16);
                boolean bMath = "math".equals(sMode) || "both".equals(sMode);
                boolean bText = "text".equals(sMode) || "both".equals(sMode);
                for (char c = c1; c <= c2; c = (char)(c + '\u0001')) {
                    this.table.addCharType(c, sType);
                    if (bMath) {
                        this.table.addMathChar(c, Character.toString(c));
                    }
                    if (!bText) continue;
                    this.table.addTextChar(c, Character.toString(c), this.nFontencs, '\u0000');
                }
            }
        }
    }

    @Override
    public void endElement(String nameSpace, String localName, String qName) {
        if (qName.equals("symbol-subset")) {
            this.bReadThisSet = this.bGlobalReadThisSet;
            this.nFontencs = this.nGlobalFontencs;
        } else if (qName.equals("special-symbol-set")) {
            if (this.b8bit) {
                this.table.table[0] = this.table.table[240];
            }
            this.b8bit = false;
        }
    }
}

