/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.LambdaExpression;
import javax.el.MethodInfo;
import javax.el.PropertyNotFoundException;
import javax.el.ValueReference;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.AstLambdaExpression;
import org.apache.el.parser.AstMethodParameters;
import org.apache.el.parser.SimpleNode;
import org.apache.el.stream.Optional;
import org.apache.el.util.MessageFactory;
import org.apache.el.util.ReflectionUtil;

public final class AstValue
extends SimpleNode {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public AstValue(int n) {
        super(n);
    }

    @Override
    public Class<?> getType(EvaluationContext evaluationContext) throws ELException {
        Target target = this.getTarget(evaluationContext);
        evaluationContext.setPropertyResolved(false);
        Class clazz = evaluationContext.getELResolver().getType((ELContext)evaluationContext, target.base, target.property);
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", target.base, target.property));
        }
        return clazz;
    }

    private Target getTarget(EvaluationContext evaluationContext) throws ELException {
        Object object = this.children[0].getValue(evaluationContext);
        if (object == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        Object object2 = null;
        int n = this.jjtGetNumChildren();
        int n2 = 1;
        ELResolver eLResolver = evaluationContext.getELResolver();
        while (n2 < n) {
            if (n2 + 2 < n && this.children[n2 + 1] instanceof AstMethodParameters) {
                object = eLResolver.invoke((ELContext)evaluationContext, object, this.children[n2].getValue(evaluationContext), null, ((AstMethodParameters)this.children[n2 + 1]).getParameters(evaluationContext));
                n2 += 2;
            } else if (n2 + 2 == n && this.children[n2 + 1] instanceof AstMethodParameters) {
                evaluationContext.setPropertyResolved(false);
                object2 = this.children[n2].getValue(evaluationContext);
                n2 += 2;
                if (object2 == null) {
                    throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", this.children[n2].getImage()));
                }
            } else if (n2 + 1 < n) {
                object2 = this.children[n2].getValue(evaluationContext);
                evaluationContext.setPropertyResolved(false);
                object = eLResolver.getValue((ELContext)evaluationContext, object, object2);
                ++n2;
            } else {
                evaluationContext.setPropertyResolved(false);
                object2 = this.children[n2].getValue(evaluationContext);
                ++n2;
                if (object2 == null) {
                    throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", this.children[n2].getImage()));
                }
            }
            if (object != null) continue;
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", this.children[n2].getImage()));
        }
        Target target = new Target();
        target.base = object;
        target.property = object2;
        return target;
    }

    @Override
    public Object getValue(EvaluationContext evaluationContext) throws ELException {
        Object object = this.children[0].getValue(evaluationContext);
        int n = this.jjtGetNumChildren();
        int n2 = 1;
        Object object2 = null;
        ELResolver eLResolver = evaluationContext.getELResolver();
        while (object != null && n2 < n) {
            object2 = this.children[n2].getValue(evaluationContext);
            if (n2 + 1 < n && this.children[n2 + 1] instanceof AstMethodParameters) {
                Object[] objectArray;
                AstMethodParameters astMethodParameters = (AstMethodParameters)this.children[n2 + 1];
                if (object instanceof Optional && "orElseGet".equals(object2) && astMethodParameters.jjtGetNumChildren() == 1 && !((objectArray = astMethodParameters.jjtGetChild(0)) instanceof AstLambdaExpression) && !(objectArray instanceof LambdaExpression)) {
                    throw new ELException(MessageFactory.get("stream.optional.paramNotLambda", object2));
                }
                objectArray = astMethodParameters.getParameters(evaluationContext);
                object = eLResolver.invoke((ELContext)evaluationContext, object, object2, (Class[])this.getTypesFromValues(objectArray), objectArray);
                n2 += 2;
                continue;
            }
            if (object2 == null) {
                return null;
            }
            evaluationContext.setPropertyResolved(false);
            object = eLResolver.getValue((ELContext)evaluationContext, object, object2);
            ++n2;
        }
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", object, object2));
        }
        return object;
    }

    @Override
    public boolean isReadOnly(EvaluationContext evaluationContext) throws ELException {
        Target target = this.getTarget(evaluationContext);
        evaluationContext.setPropertyResolved(false);
        boolean bl = evaluationContext.getELResolver().isReadOnly((ELContext)evaluationContext, target.base, target.property);
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", target.base, target.property));
        }
        return bl;
    }

    @Override
    public void setValue(EvaluationContext evaluationContext, Object object) throws ELException {
        Target target = this.getTarget(evaluationContext);
        evaluationContext.setPropertyResolved(false);
        ELResolver eLResolver = evaluationContext.getELResolver();
        Class clazz = eLResolver.getType((ELContext)evaluationContext, target.base, target.property);
        eLResolver.setValue((ELContext)evaluationContext, target.base, target.property, ELSupport.coerceToType(evaluationContext, object, clazz));
        if (!evaluationContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", target.base, target.property));
        }
    }

    public MethodInfo getMethodInfo(EvaluationContext evaluationContext, Class[] classArray) throws ELException {
        Class[] classArray2;
        Object[] objectArray;
        Target target = this.getTarget(evaluationContext);
        if (this.isParametersProvided()) {
            objectArray = ((AstMethodParameters)this.jjtGetChild(this.jjtGetNumChildren() - 1)).getParameters(evaluationContext);
            classArray2 = this.getTypesFromValues(objectArray);
        } else {
            classArray2 = classArray;
        }
        objectArray = ReflectionUtil.getMethod(evaluationContext, target.base, target.property, classArray2, null);
        return new MethodInfo(objectArray.getName(), objectArray.getReturnType(), (Class[])objectArray.getParameterTypes());
    }

    public Object invoke(EvaluationContext evaluationContext, Class[] classArray, Object[] objectArray) throws ELException {
        Object object;
        Class[] classArray2;
        Object[] objectArray2;
        Target target = this.getTarget(evaluationContext);
        if (this.isParametersProvided()) {
            objectArray2 = ((AstMethodParameters)this.jjtGetChild(this.jjtGetNumChildren() - 1)).getParameters(evaluationContext);
            classArray2 = this.getTypesFromValues(objectArray2);
        } else {
            objectArray2 = objectArray;
            classArray2 = classArray;
        }
        Method method = ReflectionUtil.getMethod(evaluationContext, target.base, target.property, classArray2, objectArray2);
        objectArray2 = this.convertArgs(evaluationContext, objectArray2, method);
        try {
            object = method.invoke(target.base, objectArray2);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new ELException((Throwable)exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof VirtualMachineError) {
                throw (VirtualMachineError)throwable;
            }
            throw new ELException(throwable);
        }
        return object;
    }

    private Object[] convertArgs(EvaluationContext evaluationContext, Object[] objectArray, Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 0) {
            return EMPTY_ARRAY;
        }
        int n = classArray.length;
        if (method.isVarArgs() && n > 1 && (objectArray == null || n > objectArray.length) || !method.isVarArgs() && (objectArray == null || objectArray.length != n)) {
            String string = null;
            if (objectArray != null) {
                string = Integer.toString(objectArray.length);
            }
            String string2 = method.isVarArgs() ? MessageFactory.get("error.invoke.tooFewParams", method.getName(), string, Integer.toString(n)) : MessageFactory.get("error.invoke.wrongParams", method.getName(), string, Integer.toString(n));
            throw new IllegalArgumentException(string2);
        }
        if (objectArray == null) {
            return new Object[1];
        }
        Object[] objectArray2 = new Object[n];
        for (int i = 0; i < n - 1; ++i) {
            objectArray2[i] = ELSupport.coerceToType(evaluationContext, objectArray[i], classArray[i]);
        }
        if (method.isVarArgs()) {
            Class<?> clazz = method.getParameterTypes()[n - 1].getComponentType();
            Object[] objectArray3 = (Object[])Array.newInstance(clazz, objectArray.length - (n - 1));
            for (int i = 0; i < objectArray.length - (n - 1); ++i) {
                objectArray3[i] = ELSupport.coerceToType(evaluationContext, objectArray[n - 1 + i], clazz);
            }
            objectArray2[n - 1] = objectArray3;
        } else {
            objectArray2[n - 1] = ELSupport.coerceToType(evaluationContext, objectArray[n - 1], classArray[n - 1]);
        }
        return objectArray2;
    }

    private Class<?>[] getTypesFromValues(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] == null ? null : objectArray[i].getClass();
        }
        return classArray;
    }

    @Override
    public ValueReference getValueReference(EvaluationContext evaluationContext) {
        if (this.children.length > 2 && this.jjtGetChild(2) instanceof AstMethodParameters) {
            return null;
        }
        Target target = this.getTarget(evaluationContext);
        return new ValueReference(target.base, target.property);
    }

    @Override
    public boolean isParametersProvided() {
        int n = this.children.length;
        if (n > 2) {
            return this.jjtGetChild(n - 1) instanceof AstMethodParameters;
        }
        return false;
    }

    protected static class Target {
        protected Object base;
        protected Object property;

        protected Target() {
        }
    }
}

