"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderAreaPath = exports.renderLinePaths = void 0;
var color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
var canvas_1 = require("../../../../../renderers/canvas");
var common_1 = require("../../../../../utils/common");
var line_1 = require("./line");
function renderLinePaths(context, transform, linePaths, stroke, clippedRanges, clippings, hideClippedRanges) {
    if (hideClippedRanges === void 0) { hideClippedRanges = false; }
    if (clippedRanges.length > 0) {
        canvas_1.withClipRanges(context, clippedRanges, clippings, false, function (ctx) {
            ctx.translate(transform.x, transform.y);
            line_1.renderMultiLine(ctx, linePaths, stroke);
        });
        if (hideClippedRanges) {
            return;
        }
        canvas_1.withClipRanges(context, clippedRanges, clippings, true, function (ctx) {
            ctx.translate(transform.x, transform.y);
            line_1.renderMultiLine(ctx, linePaths, __assign(__assign({}, stroke), { dash: [5, 5] }));
        });
        return;
    }
    canvas_1.withContext(context, function (ctx) {
        ctx.translate(transform.x, transform.y);
        line_1.renderMultiLine(ctx, linePaths, stroke);
    });
}
exports.renderLinePaths = renderLinePaths;
function renderAreaPath(ctx, transform, area, fill, clippedRanges, clippings, hideClippedRanges) {
    if (hideClippedRanges === void 0) { hideClippedRanges = false; }
    if (clippedRanges.length > 0) {
        canvas_1.withClipRanges(ctx, clippedRanges, clippings, false, function (ctx) {
            ctx.translate(transform.x, transform.y);
            renderPathFill(ctx, area, fill);
        });
        if (hideClippedRanges) {
            return;
        }
        canvas_1.withClipRanges(ctx, clippedRanges, clippings, true, function (ctx) {
            ctx.translate(transform.x, transform.y);
            var opacity = fill.color.opacity;
            var color = __assign(__assign({}, fill.color), { opacity: opacity / 2 });
            renderPathFill(ctx, area, __assign(__assign({}, fill), { color: color }));
        });
        return;
    }
    canvas_1.withContext(ctx, function (ctx) {
        ctx.translate(transform.x, transform.y);
        renderPathFill(ctx, area, fill);
    });
}
exports.renderAreaPath = renderAreaPath;
function renderPathFill(ctx, path, fill) {
    var _a, _b, _c, _d, _e;
    var path2d = new Path2D(path);
    ctx.fillStyle = color_library_wrappers_1.RGBtoString(fill.color);
    ctx.fill(path2d);
    if (fill.texture) {
        ctx.clip(path2d);
        var rotation = common_1.getRadians((_a = fill.texture.rotation) !== null && _a !== void 0 ? _a : 0);
        var offset = fill.texture.offset;
        if (offset && offset.global)
            ctx.translate((_b = offset === null || offset === void 0 ? void 0 : offset.x) !== null && _b !== void 0 ? _b : 0, (_c = offset === null || offset === void 0 ? void 0 : offset.y) !== null && _c !== void 0 ? _c : 0);
        if (rotation)
            ctx.rotate(rotation);
        if (offset && !offset.global)
            ctx.translate((_d = offset === null || offset === void 0 ? void 0 : offset.x) !== null && _d !== void 0 ? _d : 0, (_e = offset === null || offset === void 0 ? void 0 : offset.y) !== null && _e !== void 0 ? _e : 0);
        ctx.fillStyle = fill.texture.pattern;
        var rotationRectFillSize = ctx.canvas.clientWidth * ctx.canvas.clientHeight;
        ctx.translate(-rotationRectFillSize / 2, -rotationRectFillSize / 2);
        ctx.fillRect(0, 0, rotationRectFillSize, rotationRectFillSize);
    }
}
//# sourceMappingURL=path.js.map